/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.web.util.servlet.multipart;

import ai.yue.library.base.util.ApplicationContextUtils;
import ai.yue.library.web.util.servlet.multipart.MultipartRequestInputStream;
import ai.yue.library.web.util.servlet.multipart.UploadFileHeader;
import ai.yue.library.web.util.servlet.multipart.UploadProperties;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadFile {
    private static final Logger log = LoggerFactory.getLogger(UploadFile.class);
    private static final String TMP_FILE_PREFIX = "hutool-";
    private static final String TMP_FILE_SUFFIX = ".upload.tmp";
    private UploadFileHeader header;
    private UploadProperties uploadProperties;
    private int size = -1;
    private byte[] data;
    private File tempFile;

    public UploadFile(UploadFileHeader header) {
        this.header = header;
        this.uploadProperties = (UploadProperties)ApplicationContextUtils.getBean(UploadProperties.class);
    }

    public void delete() {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        if (this.data != null) {
            this.data = null;
        }
    }

    public File write(String destPath) throws IOException {
        if (this.data != null || this.tempFile != null) {
            return this.write(FileUtil.touch((String)destPath));
        }
        return null;
    }

    public File write(File destination) throws IOException {
        this.assertValid();
        if (destination.isDirectory()) {
            destination = new File(destination, this.header.getFileName());
        }
        if (this.data != null) {
            FileUtil.writeBytes((byte[])this.data, (File)destination);
            this.data = null;
        } else if (this.tempFile != null) {
            FileUtil.move((File)this.tempFile, (File)destination, (boolean)true);
        }
        return destination;
    }

    public byte[] getFileContent() throws IOException {
        this.assertValid();
        if (this.data != null) {
            return this.data;
        }
        if (this.tempFile != null) {
            return FileUtil.readBytes((File)this.tempFile);
        }
        return null;
    }

    public InputStream getFileInputStream() throws IOException {
        this.assertValid();
        if (this.data != null) {
            return new BufferedInputStream(new ByteArrayInputStream(this.data));
        }
        if (this.tempFile != null) {
            return new BufferedInputStream(new FileInputStream(this.tempFile));
        }
        return null;
    }

    public UploadFileHeader getHeader() {
        return this.header;
    }

    public String getFileName() {
        return this.header == null ? null : this.header.getFileName();
    }

    public int size() {
        return this.size;
    }

    public boolean isUploaded() {
        return this.size > 0;
    }

    public boolean isInMemory() {
        return this.data != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processStream(MultipartRequestInputStream input) throws IOException {
        if (!this.isAllowedExtension()) {
            log.debug("Forbidden uploaded file [{}]", (Object)this.getFileName());
            this.size = input.skipToBoundary();
            return false;
        }
        this.size = 0;
        int memoryThreshold = this.uploadProperties.memoryThreshold;
        if (memoryThreshold > 0) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(memoryThreshold);
            int written = input.copy(baos, memoryThreshold);
            this.data = baos.toByteArray();
            if (written <= memoryThreshold) {
                this.size = this.data.length;
                return true;
            }
        }
        this.tempFile = FileUtil.createTempFile((String)TMP_FILE_PREFIX, (String)TMP_FILE_SUFFIX, (File)FileUtil.touch((String)this.uploadProperties.tmpUploadPath), (boolean)false);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.tempFile));
        if (this.data != null) {
            this.size = this.data.length;
            out.write(this.data);
            this.data = null;
        }
        int maxFileSize = this.uploadProperties.maxFileSize;
        try {
            if (maxFileSize == -1) {
                this.size += input.copy(out);
                boolean bl = true;
                return bl;
            }
            this.size += input.copy(out, maxFileSize - this.size + 1);
            if (this.size > maxFileSize) {
                this.tempFile.delete();
                this.tempFile = null;
                log.debug("Upload file [{}] too big, file size > [{}]", (Object)this.getFileName(), (Object)maxFileSize);
                input.skipToBoundary();
                boolean bl = false;
                return bl;
            }
        }
        finally {
            IoUtil.close((Closeable)out);
        }
        return true;
    }

    private boolean isAllowedExtension() {
        List<String> exts = this.uploadProperties.fileExts;
        boolean isAllow = this.uploadProperties.isAllowFileExts;
        if (exts == null || exts.size() == 0) {
            return isAllow;
        }
        String fileNameExt = FileUtil.extName((String)this.getFileName());
        for (String fileExtension : exts) {
            if (!fileNameExt.equalsIgnoreCase(fileExtension)) continue;
            return isAllow;
        }
        return !isAllow;
    }

    private void assertValid() throws IOException {
        if (!this.isUploaded()) {
            throw new IOException(StrUtil.format((CharSequence)"File [{}] upload fail", (Object[])new Object[]{this.getFileName()}));
        }
    }
}

