/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.web.util.servlet;

import ai.yue.library.web.util.servlet.multipart.MultipartFormData;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.bean.copier.ValueProvider;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Console;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtils {
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_TRACE = "TRACE";
    public static final String HTTP_TCP_NAME = "http://";
    public static final String HTTPS_TCP_NAME = "https://";
    public static final String BEARER_TYPE = "Bearer ";
    public static final String ACCESS_TOKEN = "access_token";
    public static final String POINTCUT = "@annotation(org.springframework.web.bind.annotation.RequestMapping) || @annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.PostMapping) || @annotation(org.springframework.web.bind.annotation.PutMapping) || @annotation(org.springframework.web.bind.annotation.PatchMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping)";

    public static ServletRequestAttributes getRequestAttributes() {
        return (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return requestAttributes == null ? null : ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static HttpServletResponse getResponse() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return requestAttributes == null ? null : ((ServletRequestAttributes)requestAttributes).getResponse();
    }

    public static HttpSession getSession() {
        return ServletUtils.getRequest().getSession();
    }

    public static String getAuthToken() {
        return ServletUtils.getAuthToken(ServletUtils.getRequest());
    }

    public static String getAuthToken(HttpServletRequest request) {
        String authToken = StrUtil.subAfter((CharSequence)request.getHeader("Authorization"), (CharSequence)BEARER_TYPE, (boolean)false);
        if (StrUtil.isBlank((CharSequence)authToken)) {
            authToken = request.getParameter(ACCESS_TOKEN);
        }
        return authToken;
    }

    public static String getServerURL() {
        HttpServletRequest request = ServletUtils.getRequest();
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        String contextPath = request.getContextPath();
        return HTTP_TCP_NAME + serverName + ":" + serverPort + contextPath;
    }

    public static void printRequest() {
        HttpServletRequest request = ServletUtils.getRequest();
        Console.error((Object)"========\u5f00\u59cb-\u6253\u5370\u8bf7\u6c42\u62a5\u6587========");
        Console.log();
        Console.log((Object)"\u6253\u5370\u8bf7\u6c42\u4fe1\u606f\uff1a");
        Console.log((String)"RemoteAddr\uff1a{}", (Object[])new Object[]{request.getRemoteAddr()});
        Console.log((String)"Method\uff1a{}", (Object[])new Object[]{request.getMethod()});
        Console.log((String)"AuthType\uff1a{}", (Object[])new Object[]{request.getAuthType()});
        Console.log();
        Console.log((Object)"\u6253\u5370\u670d\u52a1\u5668\u4fe1\u606f\uff1a");
        Console.log((String)"ServerURL\uff1a{}", (Object[])new Object[]{ServletUtils.getServerURL()});
        Console.log((String)"RequestURL\uff1a{}", (Object[])new Object[]{request.getRequestURL()});
        Console.log((String)"RequestedSessionId\uff1a{}", (Object[])new Object[]{request.getRequestedSessionId()});
        Console.log();
        Console.log((Object)"\u6253\u5370\u8bf7\u6c42\u53c2\u6570\uff1a");
        Console.log((String)"QueryString\uff1a{}", (Object[])new Object[]{request.getQueryString()});
        Console.log((String)"ParameterMap\uff1a{}", (Object[])new Object[]{JSONObject.toJSONString((Object)request.getParameterMap())});
        Console.log();
        Console.log((Object)"\u6253\u5370\u8bf7\u6c42\u5934\uff1a");
        Console.log((Object)"Headers\uff1a");
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            StringBuilder headerValues = new StringBuilder();
            Enumeration headerNames2 = request.getHeaders(headerName);
            while (headerNames2.hasMoreElements()) {
                String headerValue = (String)headerNames2.nextElement();
                headerValues.append(headerValue);
            }
            Console.log((String)"\u3000\u3000{}\uff1a{}", (Object[])new Object[]{headerName, headerValues});
        }
        Console.log();
        Console.log((Object)"Cookies\uff1a");
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                Console.log((String)"\u3000\u3000{}\uff1a{}", (Object[])new Object[]{cookie.getName(), cookie.getValue()});
            }
        }
        Console.error((Object)"========\u7ed3\u675f-\u6253\u5370\u8bf7\u6c42\u62a5\u6587========");
    }

    public static Map<String, String[]> getParams(ServletRequest request) {
        Map map = request.getParameterMap();
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, String> getParamMap(ServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : ServletUtils.getParams(request).entrySet()) {
            params.put(entry.getKey(), ArrayUtil.join((Object[])entry.getValue(), (CharSequence)","));
        }
        return params;
    }

    public static String getBody(ServletRequest request) {
        try {
            return IoUtil.read((Reader)request.getReader());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static byte[] getBodyBytes(ServletRequest request) {
        try {
            return IoUtil.readBytes((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static <T> T fillBean(final ServletRequest request, T bean, CopyOptions copyOptions) {
        final String beanName = StrUtil.lowerFirst((CharSequence)bean.getClass().getSimpleName());
        return (T)BeanUtil.fillBean(bean, (ValueProvider)new ValueProvider<String>(){

            public Object value(String key, Type valueType) {
                Object[] values = request.getParameterValues(key);
                if (ArrayUtil.isEmpty((Object[])values) && ArrayUtil.isEmpty((Object[])(values = request.getParameterValues(beanName + "." + key)))) {
                    return null;
                }
                if (1 == values.length) {
                    return values[0];
                }
                return values;
            }

            public boolean containsKey(String key) {
                return null != request.getParameter(key) || null != request.getParameter(beanName + "." + key);
            }
        }, (CopyOptions)copyOptions);
    }

    public static <T> T fillBean(ServletRequest request, T bean, boolean isIgnoreError) {
        return ServletUtils.fillBean(request, bean, CopyOptions.create().setIgnoreError(isIgnoreError));
    }

    public static <T> T toBean(ServletRequest request, Class<T> beanClass, boolean isIgnoreError) {
        return (T)ServletUtils.fillBean(request, ReflectUtil.newInstanceIfPossible(beanClass), isIgnoreError);
    }

    public static String getClientIP(String ... otherHeaderNames) {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtil.isNotEmpty((Object[])otherHeaderNames)) {
            headers = (String[])ArrayUtil.addAll((Object[][])new String[][]{headers, otherHeaderNames});
        }
        return ServletUtils.getClientIPByHeader(headers);
    }

    public static String getClientIPByHeader(String ... headerNames) {
        String ip;
        HttpServletRequest request = ServletUtils.getRequest();
        for (String header : headerNames) {
            ip = request.getHeader(header);
            if (ServletUtils.isUnknow(ip)) continue;
            return ServletUtils.getMultistageReverseProxyIp(ip);
        }
        ip = request.getRemoteAddr();
        return ServletUtils.getMultistageReverseProxyIp(ip);
    }

    public static MultipartFormData getMultipart() throws IORuntimeException {
        MultipartFormData formData = new MultipartFormData();
        try {
            formData.parseRequest((ServletRequest)ServletUtils.getRequest());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return formData;
    }

    public static Map<String, String> getHeaderMap() {
        HttpServletRequest request = ServletUtils.getRequest();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            headerMap.put(name, request.getHeader(name));
        }
        return headerMap;
    }

    public static String getHeaderIgnoreCase(String nameIgnoreCase) {
        HttpServletRequest request = ServletUtils.getRequest();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name == null || !name.equalsIgnoreCase(nameIgnoreCase)) continue;
            return request.getHeader(name);
        }
        return null;
    }

    public static String getHeader(String name, String charsetName) {
        return ServletUtils.getHeader(name, CharsetUtil.charset((String)charsetName));
    }

    public static String getHeader(String name, Charset charset) {
        String header = ServletUtils.getRequest().getHeader(name);
        if (null != header) {
            return CharsetUtil.convert((String)header, (Charset)CharsetUtil.CHARSET_ISO_8859_1, (Charset)charset);
        }
        return null;
    }

    public static boolean isIE() {
        String userAgent = ServletUtils.getHeaderIgnoreCase("User-Agent");
        if (StrUtil.isNotBlank((CharSequence)userAgent)) {
            return (userAgent = userAgent.toUpperCase()).contains("MSIE") || userAgent.contains("TRIDENT");
        }
        return false;
    }

    public static boolean isGetMethod() {
        return METHOD_GET.equalsIgnoreCase(ServletUtils.getRequest().getMethod());
    }

    public static boolean isPostMethod() {
        return METHOD_POST.equalsIgnoreCase(ServletUtils.getRequest().getMethod());
    }

    public static boolean isMultipart() {
        if (!ServletUtils.isPostMethod()) {
            return false;
        }
        String contentType = ServletUtils.getRequest().getContentType();
        if (StrUtil.isBlank((CharSequence)contentType)) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public static Cookie getCookie(String name) {
        return ServletUtils.readCookieMap().get(name);
    }

    public static Map<String, Cookie> readCookieMap() {
        CaseInsensitiveMap cookieMap = new CaseInsensitiveMap();
        Cookie[] cookies = ServletUtils.getRequest().getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        return cookieMap;
    }

    public static void addCookie(Cookie cookie) {
        ServletUtils.getResponse().addCookie(cookie);
    }

    public static void addCookie(String name, String value) {
        ServletUtils.getResponse().addCookie(new Cookie(name, value));
    }

    public static void addCookie(String name, String value, int maxAgeInSeconds, String path, String domain) {
        Cookie cookie = new Cookie(name, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setPath(path);
        ServletUtils.addCookie(cookie);
    }

    public static void addCookie(String name, String value, int maxAgeInSeconds) {
        ServletUtils.addCookie(name, value, maxAgeInSeconds, "/", null);
    }

    public static PrintWriter getWriter() throws IORuntimeException {
        try {
            return ServletUtils.getResponse().getWriter();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static void write(String text, String contentType) {
        HttpServletResponse response = ServletUtils.getResponse();
        response.setContentType(contentType);
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            ((Writer)writer).write(text);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new UtilException((Throwable)e);
        }
        finally {
            IoUtil.close((Closeable)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file) {
        String fileName = file.getName();
        String contentType = (String)ObjectUtil.defaultIfNull((Object)FileUtil.getMimeType((String)fileName), (Object)"application/octet-stream");
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream((File)file);
            ServletUtils.write(in, contentType, fileName);
        }
        finally {
            IoUtil.close((Closeable)in);
        }
    }

    public static void write(InputStream in, String contentType, String fileName) {
        HttpServletResponse response = ServletUtils.getResponse();
        String charset = (String)ObjectUtil.defaultIfNull((Object)response.getCharacterEncoding(), (Object)"UTF-8");
        response.setHeader("Content-Disposition", StrUtil.format((CharSequence)"attachment;filename={}", (Object[])new Object[]{URLUtil.encode((String)fileName, (String)charset)}));
        response.setContentType(contentType);
        ServletUtils.write(in);
    }

    public static void write(InputStream in, String contentType) {
        ServletUtils.getResponse().setContentType(contentType);
        ServletUtils.write(in);
    }

    public static void write(InputStream in) {
        ServletUtils.write(in, 8192);
    }

    public static void write(InputStream in, int bufferSize) {
        ServletOutputStream out = null;
        try {
            out = ServletUtils.getResponse().getOutputStream();
            IoUtil.copy((InputStream)in, (OutputStream)out, (int)bufferSize);
        }
        catch (IOException e) {
            throw new UtilException((Throwable)e);
        }
        finally {
            IoUtil.close((Closeable)out);
            IoUtil.close((Closeable)in);
        }
    }

    public static void setHeader(String name, Object value) {
        HttpServletResponse response = ServletUtils.getResponse();
        if (value instanceof String) {
            response.setHeader(name, (String)value);
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            response.setDateHeader(name, ((Date)value).getTime());
        } else if (value instanceof Integer || "int".equals(value.getClass().getSimpleName().toLowerCase())) {
            response.setIntHeader(name, ((Integer)value).intValue());
        } else {
            response.setHeader(name, value.toString());
        }
    }

    private static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (ServletUtils.isUnknow(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    private static boolean isUnknow(String checkString) {
        return StrUtil.isBlank((CharSequence)checkString) || "unknown".equalsIgnoreCase(checkString);
    }
}

