/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.webflux.config.api.version;

import ai.yue.library.base.annotation.api.version.ApiVersion;
import ai.yue.library.base.annotation.api.version.ApiVersionProperties;
import ai.yue.library.base.exception.ApiVersionDeprecatedException;
import ai.yue.library.base.util.StringUtils;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.reactive.result.condition.RequestCondition;
import org.springframework.web.server.ServerWebExchange;

public class ApiVersionRequestCondition
implements RequestCondition<ApiVersionRequestCondition> {
    private ApiVersion apiVersion;
    private ApiVersionProperties apiVersionProperties;
    private Integer versionPlaceholderIndex;

    public ApiVersionRequestCondition combine(ApiVersionRequestCondition apiVersionRequestCondition) {
        return new ApiVersionRequestCondition(apiVersionRequestCondition.getApiVersion(), apiVersionRequestCondition.getApiVersionProperties(), apiVersionRequestCondition.getVersionPlaceholderIndex());
    }

    public ApiVersionRequestCondition getMatchingCondition(ServerWebExchange exchange) {
        double apiVersionValue;
        ServerHttpRequest serverHttpRequest = exchange.getRequest();
        String requestURI = serverHttpRequest.getURI().getPath();
        String[] versionPaths = StringUtils.split((CharSequence)requestURI, (CharSequence)"/");
        double pathVersion = Double.valueOf(versionPaths[this.versionPlaceholderIndex].substring(1));
        if (pathVersion >= (apiVersionValue = this.getApiVersion().value())) {
            double minimumVersion = this.apiVersionProperties.getMinimumVersion();
            if ((this.getApiVersion().deprecated() || minimumVersion >= pathVersion) && pathVersion == apiVersionValue) {
                throw new ApiVersionDeprecatedException(StrUtil.format((CharSequence)"\u5ba2\u6237\u7aef\u8c03\u7528\u5f03\u7528\u7248\u672cAPI\u63a5\u53e3\uff0crequestURI\uff1a{}", (Object[])new Object[]{requestURI}));
            }
            if (this.getApiVersion().deprecated()) {
                return null;
            }
            return this;
        }
        return null;
    }

    public int compareTo(ApiVersionRequestCondition apiVersionRequestCondition, ServerWebExchange exchange) {
        return NumberUtil.compare((double)apiVersionRequestCondition.getApiVersion().value(), (double)this.getApiVersion().value());
    }

    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public ApiVersionProperties getApiVersionProperties() {
        return this.apiVersionProperties;
    }

    public Integer getVersionPlaceholderIndex() {
        return this.versionPlaceholderIndex;
    }

    public void setApiVersion(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setApiVersionProperties(ApiVersionProperties apiVersionProperties) {
        this.apiVersionProperties = apiVersionProperties;
    }

    public void setVersionPlaceholderIndex(Integer versionPlaceholderIndex) {
        this.versionPlaceholderIndex = versionPlaceholderIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiVersionRequestCondition)) {
            return false;
        }
        ApiVersionRequestCondition other = (ApiVersionRequestCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApiVersion this$apiVersion = this.getApiVersion();
        ApiVersion other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        ApiVersionProperties this$apiVersionProperties = this.getApiVersionProperties();
        ApiVersionProperties other$apiVersionProperties = other.getApiVersionProperties();
        if (this$apiVersionProperties == null ? other$apiVersionProperties != null : !this$apiVersionProperties.equals(other$apiVersionProperties)) {
            return false;
        }
        Integer this$versionPlaceholderIndex = this.getVersionPlaceholderIndex();
        Integer other$versionPlaceholderIndex = other.getVersionPlaceholderIndex();
        return !(this$versionPlaceholderIndex == null ? other$versionPlaceholderIndex != null : !((Object)this$versionPlaceholderIndex).equals(other$versionPlaceholderIndex));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiVersionRequestCondition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiVersion $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        ApiVersionProperties $apiVersionProperties = this.getApiVersionProperties();
        result = result * 59 + ($apiVersionProperties == null ? 43 : $apiVersionProperties.hashCode());
        Integer $versionPlaceholderIndex = this.getVersionPlaceholderIndex();
        result = result * 59 + ($versionPlaceholderIndex == null ? 43 : ((Object)$versionPlaceholderIndex).hashCode());
        return result;
    }

    public String toString() {
        return "ApiVersionRequestCondition(apiVersion=" + this.getApiVersion() + ", apiVersionProperties=" + this.getApiVersionProperties() + ", versionPlaceholderIndex=" + this.getVersionPlaceholderIndex() + ")";
    }

    public ApiVersionRequestCondition(ApiVersion apiVersion, ApiVersionProperties apiVersionProperties, Integer versionPlaceholderIndex) {
        this.apiVersion = apiVersion;
        this.apiVersionProperties = apiVersionProperties;
        this.versionPlaceholderIndex = versionPlaceholderIndex;
    }
}

