/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.webflux.config.handler;

import ai.yue.library.base.config.handler.AbstractExceptionHandler;
import ai.yue.library.base.exception.AuthorizeException;
import ai.yue.library.base.exception.ParamDecryptException;
import ai.yue.library.base.exception.ParamException;
import ai.yue.library.base.exception.ParamVoidException;
import ai.yue.library.base.exception.ResultException;
import ai.yue.library.base.util.ExceptionUtils;
import ai.yue.library.base.view.Result;
import ai.yue.library.base.view.ResultInfo;
import cn.hutool.core.exceptions.ValidateException;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@ConditionalOnProperty(prefix="yue.exception-handler", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ExceptionHandlerConfig
extends AbstractExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandlerConfig.class);

    @ResponseBody
    @ExceptionHandler(value={ResultException.class})
    public synchronized Result<?> resultExceptionHandler(ResultException e) {
        Result result = e.getResult();
        log.error(result.toString());
        ExceptionUtils.printException((Exception)e);
        return result;
    }

    @ResponseBody
    @ExceptionHandler(value={ParamVoidException.class})
    public Result<?> paramVoidExceptionHandler() {
        return ResultInfo.paramVoid();
    }

    @ResponseBody
    @ExceptionHandler(value={ParamException.class})
    public Result<?> paramExceptionHandler(ParamException e) {
        ExceptionUtils.printException((Exception)e);
        return ResultInfo.paramCheckNotPass((String)e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={BindException.class})
    public Result<?> bindExceptionHandler(BindException e) {
        List errors = e.getAllErrors();
        JSONObject paramHint = new JSONObject();
        errors.forEach(error -> {
            String str = StrUtil.subAfter((CharSequence)error.getArguments()[0].toString(), (CharSequence)"[", (boolean)true);
            String key = str.substring(0, str.length() - 1);
            String msg = error.getDefaultMessage();
            paramHint.put(key, (Object)msg);
            Console.error((Object)(key + " " + msg));
        });
        return ResultInfo.paramCheckNotPass((String)paramHint.toString());
    }

    @ResponseBody
    @ExceptionHandler(value={ValidateException.class})
    public Result<?> validateExceptionHandler(ValidateException e) {
        ExceptionUtils.printException((Exception)e);
        return ResultInfo.paramCheckNotPass((String)e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={ParamDecryptException.class})
    public Result<?> paramDecryptExceptionHandler(ParamDecryptException e) {
        log.error("\u3010\u89e3\u5bc6\u9519\u8bef\u3011\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)e.getMessage());
        ExceptionUtils.printException((Exception)e);
        return ResultInfo.paramDecryptError();
    }

    @ExceptionHandler(value={AuthorizeException.class})
    public void authorizeExceptionHandler(AuthorizeException e) throws IOException {
        ExceptionUtils.printException((Exception)e);
        log.error("WebFlux \u6682\u4e0d\u652f\u6301\u5f02\u5e38\u62e6\u622a\u540e\u91cd\u5b9a\u5411\u64cd\u4f5c ...");
    }
}

