/*
 * Decompiled with CFR 0.152.
 */
package ai.yue.library.webflux.config.exception;

import ai.yue.library.base.view.Result;
import java.util.List;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.method.annotation.ResponseBodyResultHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ResultResponseBodyHandler
extends ResponseBodyResultHandler {
    public ResultResponseBodyHandler(List<HttpMessageWriter<?>> writers, RequestedContentTypeResolver resolver, ReactiveAdapterRegistry registry) {
        super(writers, resolver, registry);
        this.setOrder(99);
    }

    public boolean supports(HandlerResult result) {
        if (!super.supports(result)) {
            return false;
        }
        return result.getReturnType().getRawClass() == Result.class;
    }

    public Mono<Void> handleResult(ServerWebExchange exchange, HandlerResult result) {
        Object body = result.getReturnValue();
        Integer code = null;
        if (body instanceof Result) {
            code = ((Result)body).getCode();
        }
        ServerHttpResponse response = exchange.getResponse();
        int status = response.getRawStatusCode();
        if (code != null && code != status) {
            response.setRawStatusCode(code);
        }
        return super.handleResult(exchange, result);
    }
}

