package com.alan.alansdk.prefs;

import android.content.Context;
import android.content.SharedPreferences;

import com.google.gson.Gson;
import java.util.Map;
import java.util.UUID;

public class AlanPrefs {

    public static final String DEF_WAKEWORD_NAME = "model_20191008.tflite";
    public static final Boolean DEFAULT_WAKEWORD_STATE = false;
    public static final Long DEFAULT_TIMEOUT = 10000L;

    private Context context;
    private SharedPreferences prefs;
    private String prefsPath = "AlanSDKPreferences";
    private String prefsHost = "";
    private String prefsProjectId = "";

    private static final String PREF_UUID = "uuid";
    private static final String PREF_WAKE_WORD_ENABLED = "wake_word";
    private static final String PREF_TIMEOUT = "timeout";
    private static final String PREF_BUTTON_HIDDEN = "hidden";
    private static final String PREF_WAKE_WORD_MODEL_URL = "wake_word_model_url";
    private static final String PREF_HIDE_S2T_PANEL = "hide_s2t_panel";
    private static final String PREF_SCREENSHOTS_ENABLED = "screenshots_enabled";
    private static final String PREF_KEEP_MICROPHONE_IN_BACKGROUND = "keep_microphone_in_background";
    private static final String PREF_WAKEWORD_IN_BACKGROUND = "wakeword_in_background";
    private static final String PREF_CUSTOM_LOGO = "logoUrl";
    private static final String PREF_CUSTOM_LOGO_IDLE = "logoIdle";
    private static final String PREF_CUSTOM_LOGO_LISTEN = "logoListen";
    private static final String PREF_CUSTOM_LOGO_PROCESS = "logoProcess";
    private static final String PREF_CUSTOM_LOGO_REPLY = "logoReply";
    private static final String PREF_CUSTOM_LOGOS = "logoUrls";

    public AlanPrefs(Context context) {
        context = context;
        prefs = context.getSharedPreferences(prefsPath, Context.MODE_PRIVATE);
    }

    public void updatePath(Context context, String host, String projectId) {
        if (prefsHost.equals(host) && prefsProjectId.equals(projectId)) {
            return;
        }
        prefsHost = host;
        prefsProjectId = projectId;

        context = context;
        String preferencesPath = prefsPath.concat(":").concat(host).concat(":").concat(projectId).replaceAll("[/]", "");
        prefs = context.getSharedPreferences(preferencesPath, Context.MODE_PRIVATE);
    }

    public void setCustomLogo(String customLogoName) {
        prefs.edit().putString(PREF_CUSTOM_LOGO, customLogoName).apply();
    }

    public String getCustomLogo() {
        return prefs.getString(PREF_CUSTOM_LOGO, "");
    }

    public void setCustomLogos(Map<String, String> customLogos) {
        String customLogosString = new Gson().toJson(customLogos);
        prefs.edit().putString(PREF_CUSTOM_LOGOS, customLogosString).apply();
    }

    public Map<String, String> getCustomLogos() {
        String customLogosString = prefs.getString(PREF_CUSTOM_LOGOS, "");
        return new Gson().fromJson(customLogosString, Map.class);
    }

    public void setButtonHidden(boolean hidden) {
        prefs.edit().putBoolean(PREF_BUTTON_HIDDEN, hidden).apply();
    }

    public boolean isButtonHidden() {
        return prefs.getBoolean(PREF_BUTTON_HIDDEN, true);
    }

    public void setWakeWordState(boolean enabled) {
        prefs.edit().putBoolean(PREF_WAKE_WORD_ENABLED, enabled).apply();
    }

    public boolean isWakeWordEnabled() {
        return prefs.getBoolean(PREF_WAKE_WORD_ENABLED, DEFAULT_WAKEWORD_STATE);
    }

    public void setHideS2TPanel(boolean hide) {
        prefs.edit().putBoolean(PREF_HIDE_S2T_PANEL, hide).apply();
    }

    public boolean hideS2TPanel() {
        return prefs.getBoolean(PREF_HIDE_S2T_PANEL, false);
    }

    public void setScreenshotsEnabled(boolean screenshotsEnabled) {
        prefs.edit().putBoolean(PREF_SCREENSHOTS_ENABLED, screenshotsEnabled).apply();
    }

    public boolean isScreenshotsEnabled() {
        return prefs.getBoolean(PREF_SCREENSHOTS_ENABLED, false);
    }

    public void setKeepMicrophoneInBackground(boolean keepMicrophoneInBackground) {
        prefs.edit().putBoolean(PREF_KEEP_MICROPHONE_IN_BACKGROUND, keepMicrophoneInBackground).apply();
    }

    public boolean keepMicrophoneInBackground() {
        return prefs.getBoolean(PREF_KEEP_MICROPHONE_IN_BACKGROUND, true);
    }

    public void setWakewordInBackground(boolean wakewordInBackground) {
        prefs.edit().putBoolean(PREF_WAKEWORD_IN_BACKGROUND, wakewordInBackground).apply();
    }

    public boolean wakewordInBackground() {
        return prefs.getBoolean(PREF_WAKEWORD_IN_BACKGROUND, false);
    }

    public void setTimeout(long timeout) {
        prefs.edit().putLong(PREF_TIMEOUT, timeout).apply();
    }

    public Long getTimeout() {
        return prefs.getLong(PREF_TIMEOUT, DEFAULT_TIMEOUT);
    }

    public void setWakeWordModelUrl(String url) {
        prefs.edit().putString(PREF_WAKE_WORD_MODEL_URL, url).apply();
    }

    public String getWakeWordModelUrl() {
        return prefs.getString(PREF_WAKE_WORD_MODEL_URL, "");
    }

    public String getUUID() {
        String uuidPref = prefs.getString(PREF_UUID, "");
        if (uuidPref.isEmpty()) {
            uuidPref = UUID.randomUUID().toString();
            prefs.edit().putString(PREF_UUID, uuidPref).apply();
        }
        return uuidPref;
    }

}
