package com.alan.alansdk.alanbase.recorder;

import android.annotation.TargetApi;
import android.media.AudioFormat;
import android.media.AudioRecord;
import android.media.MediaRecorder;
import android.os.Build;

import com.alan.alansdk.alanbase.AudioConfig;
import com.alan.alansdk.logging.AlanLogger;

import java.util.Arrays;

@TargetApi(Build.VERSION_CODES.M)
public class RecorderApi23 extends RecorderThread {
    private float[] audioBuffer;
    private int samplesToSkip = 0;

    public RecorderApi23(RecordDumpListener callback) {
        super(callback);
    }

    @Override
    protected void skip(int samples) {
        samplesToSkip = samples;
    }

    @Override
    protected boolean prepareRecorder() {
        int bufferSize = AudioRecord.getMinBufferSize(
                AudioConfig.SAMPLE_RATE,
                AudioFormat.CHANNEL_IN_MONO,
                AudioFormat.ENCODING_PCM_FLOAT
        );

        if (bufferSize == AudioRecord.ERROR || bufferSize == AudioRecord.ERROR_BAD_VALUE) {
            bufferSize = AudioConfig.SAMPLE_RATE * 2;
        }

        audioBuffer = new float[bufferSize / 2];

        record = new AudioRecord(
                MediaRecorder.AudioSource.MIC,
                AudioConfig.SAMPLE_RATE,
                AudioFormat.CHANNEL_IN_MONO,
                AudioFormat.ENCODING_PCM_FLOAT,
                bufferSize
        );

        if (record.getState() != AudioRecord.STATE_INITIALIZED) {
            AlanLogger.e("Audio Record can't initialize!");
            return false;
        }

        shouldContinue = true;
        return shouldContinue;
    }

    @Override
    protected void writeFrames() {
        if (audioBuffer.length > 0) {
            if (samplesToSkip > 0) {
                int skip = Math.min(audioBuffer.length, samplesToSkip);
                samplesToSkip -= skip;
                if (skip >= audioBuffer.length) {
                    return;
                } else {
                    float[] skippedBuffer = Arrays.copyOfRange(audioBuffer, skip, audioBuffer.length);
                    callback.onRecordDump(skippedBuffer);
                }
            } else {
                callback.onRecordDump(audioBuffer);
            }
        }
    }

    @Override
    protected int readBuffer() {
        return record.read(audioBuffer, 0, audioBuffer.length, AudioRecord.READ_BLOCKING);
    }
}
