package com.alan.alansdk.button.animations;

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;

public class PopupXAnimation {

    final private View popup;

    public PopupXAnimation(View popupView) {
        this.popup = popupView;
    }

    public void animate(float newX) {
        AnimatorSet anim = new AnimatorSet();
        ObjectAnimator setXAnimation = getXAnimation(popup, newX);
        anim.play(setXAnimation);
        anim.start();
    }

    private ObjectAnimator getXAnimation(View view, float target) {
        ObjectAnimator animation = ObjectAnimator.ofFloat(view, "x", view.getX(), target);
        animation.setDuration(AnimationConfig.POPUP_X_ANIMATION_TIME);
        animation.setInterpolator(new AccelerateDecelerateInterpolator());
        animation.setRepeatCount(0);
        return animation;
    }
}
