package com.alan.alansdk.alanbase.recorder;

import android.os.Build;

import androidx.annotation.Keep;

import com.alan.alansdk.Alan;
import com.alan.alansdk.logging.AlanLogger;

public class AlanRecorder implements RecordDumpListener {

    private Alan alan;

    public AlanRecorder(Alan alan) {
        this.alan = alan;
    }

    private RecorderThread recorderThread;

    public void stopRecording() {
        if (recorderThread == null || !recorderThread.shouldContinue) {
            return;
        }
        recorderThread.stopRecording();
    }

    public void startRecording() {
        if (recorderThread != null && recorderThread.isAlive()) {
            AlanLogger.i("Recorder already started");
            return;
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            recorderThread = new RecorderApi23(this);
        } else {
            recorderThread = new RecorderApi21(this);
        }
        recorderThread.start();
    }

    public void skipMillis(int millis) {
        if (recorderThread != null) {
            recorderThread.skipMillis(millis);
        }
    }

    @Override
    public void onRecordDump(float[] dump) {
        alan.writeFrameNative(dump);
    }
}
