package com.alan.alansdk.alanbase.speaker;

import android.os.Build;

import androidx.annotation.Keep;

import com.alan.alansdk.Alan;
import com.alan.alansdk.logging.AlanLogger;

public class AlanARMSpeaker implements SpeakerDumpListener, AlanSpeaker {

    private SpeakerThread speakerThread;
    private Alan alan;

    public AlanARMSpeaker(Alan alan) {
        this.alan = alan;
    }

    @Override
    public void stopPlaying() {
        if (speakerThread == null) {
            return;
        }
        speakerThread.stopPlaying();
    }

    @Override
    public void release() {
        if (speakerThread == null) {
            return;
        }
        try {
            speakerThread.release();
            speakerThread.join();
        } catch (InterruptedException e) {
            AlanLogger.e(e);
        }
    }

    @Override
    public void startPlaying() {
        if (speakerThread == null || !speakerThread.isAlive()) {
//            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                speakerThread = new SpeakerThread(this);
//            } else {
//                speakerThread = new SpeakerApi21(this);
//            }
            speakerThread.start();
        }
        speakerThread.interrupt();
    }

    @Override
    public float[] retrieveAudioBuffer() {
        return alan.readFromNative();
    }
}
