package com.alan.alansdk.button.animations;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.view.View;
import android.view.animation.LinearInterpolator;

public class HintHideAnimation extends BaseAnimation {

    private View hintView;

    public HintHideAnimation(View hintView) {
        this.hintView = hintView;
    }

    @Override
    protected AnimatorSet buildAnimator() {
        anim = new AnimatorSet();

        ObjectAnimator fadeAnimation = getAlphaAnimation(hintView);
        anim.play(fadeAnimation);
        anim.addListener(new Animator.AnimatorListener() {
            @Override
            public void onAnimationStart(Animator animation) {

            }

            @Override
            public void onAnimationEnd(Animator animation) {
                hintView.setVisibility(View.GONE);
//                hintView.setAlpha(1.0f);
            }

            @Override
            public void onAnimationCancel(Animator animation) {
            }

            @Override
            public void onAnimationRepeat(Animator animation) {

            }
        });
        return anim;
    }

    private ObjectAnimator getAlphaAnimation(View view) {

        ObjectAnimator animation = ObjectAnimator.ofFloat(view,
                "alpha",
                1.0f, 0.0f);

        animation.setDuration(AnimationConfig.HINT_HIDE_ANIMATION_TIME);
        animation.setInterpolator(new LinearInterpolator());
        animation.setRepeatCount(0);
        return animation;
    }
}
