package com.alan.alansdk.button.animations;

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;

import com.alan.alansdk.button.GradientButton;

public class LoaderAnimation extends BaseAnimation {

    private ImageView loaderView;

    public LoaderAnimation(ImageView loaderView) {
        this.loaderView = loaderView;
    }

    @Override
    protected AnimatorSet buildAnimator() {
        anim = new AnimatorSet();
        ObjectAnimator bgAnimation = getAnimation(loaderView);
        anim.play(bgAnimation);
        return anim;
    }

    private ObjectAnimator getAnimation(View view) {
        ObjectAnimator animation = ObjectAnimator.ofFloat(view,
                "rotation",
                0.0f, 360.0f);
        animation.setRepeatCount(ValueAnimator.INFINITE);
        animation.setRepeatMode(ValueAnimator.RESTART);
        animation.setDuration(2000);
        animation.setInterpolator(new LinearInterpolator());
        return animation;
    }

    @Override
    public void stopAnimation() {
        super.stopAnimation();
        loaderView.setImageAlpha(0);
    }

    @Override
    public void startAnimation() {
        super.startAnimation();
        loaderView.setImageAlpha(255);
    }

}
