package com.alan.alansdk.button;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.alan.alansdk.R;

public class GradientButton extends View {
    
    public GradientButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    private Paint gradientPaint;
    private Paint basePaint = new Paint();
    private Bitmap blurBitmap;
    private Paint blurPaint = new Paint();
    private Rect blurRect;
    private Rect blurDstRect;

    private boolean isInited = false;
    private int color1 = Color.parseColor("#1eb6e5");
    private int color2 = Color.parseColor("#1995ff");;

    private void init(int color1, int color2) {
        gradientPaint = new Paint();
        gradientPaint.setAntiAlias(true);
        gradientPaint.setDither(false);
        gradientPaint.setAlpha(200);

        blurBitmap = BitmapFactory.decodeResource(getContext().getResources(), R.drawable.button_blur);
        blurRect = new Rect(0, 0, blurBitmap.getWidth(), blurBitmap.getHeight());
        blurDstRect = new Rect(0, 0, getWidth(), getWidth());
        blurPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.OVERLAY));

        isInited = true;

        setColors(color1, color2);
    }

    public void setColors(int color1, int color2) {
        this.color1 = color1;
        this.color2 = color2;

        if (!isInited) {
            init(color1, color2);
            return;
        }

        LinearGradient gradient = new LinearGradient(0, 0, getWidth(), getHeight(), color1, color2, android.graphics.Shader.TileMode.CLAMP);
        gradientPaint.setShader(gradient);
        blurPaint.setShader(gradient);

        invalidate();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        if (!isInited) {
            init(color1, color2);
            return;
        }

        canvas.drawBitmap(blurBitmap, blurRect, blurDstRect, basePaint);
        canvas.drawCircle(getWidth() / 2.0f, getHeight() / 2.0f, (getWidth() / 2.0f), blurPaint);
        canvas.drawCircle(getWidth() / 2.0f, getHeight() / 2.0f, getWidth() / 2.0f, gradientPaint);
    }
}
