package com.alan.alansdk.alanbase;

import android.content.Context;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.MediaRecorder;
import android.content.pm.PackageManager;
import android.os.Build;

import com.alan.alansdk.AlanConfig;
import com.alan.alansdk.Utils;
import com.alan.alansdk.logging.AlanLogger;

public class AudioConfig {
    public static int SAMPLE_RATE = 44100;

    public final static int SKIP_MILLIS_ON_START = 430;

    public static void determineSupportedSampleRate(boolean isTV) {
        AlanLogger.i("Determine supported sample rate");
        if (!isTV) {
            int[] sample_rates = new int[]{44100, 16000};
            for (int sample_rate : sample_rates) {
                AlanLogger.i("Determine supported sample rate - " + sample_rate);
                if (validateSampleRate(sample_rate)) {
                    AlanLogger.i("Determined sample rate - " + sample_rate);
                    SAMPLE_RATE = sample_rate;
                    break;
                }
            }
        } else {
            AlanLogger.i("Use fixed sample rate for tv - 44100");
        }
    }

    public static boolean validateSampleRate(int sample_rate) {
        AudioRecord recorder = null;
        try {
            int bufferSize = AudioRecord.getMinBufferSize(
                    sample_rate,
                    AudioFormat.CHANNEL_IN_MONO,
                    AudioFormat.ENCODING_PCM_FLOAT
            );
            AlanLogger.i("Validate sample rate - bufferSize - " + bufferSize);
            recorder = new AudioRecord(
                    MediaRecorder.AudioSource.MIC,
                    sample_rate,
                    AudioFormat.CHANNEL_IN_MONO,
                    AudioFormat.ENCODING_PCM_FLOAT,
                    bufferSize
            );
        } catch(IllegalArgumentException e) {
            AlanLogger.e(e);
            return false;
        } finally {
            if(recorder != null)
                recorder.release();
        }
        return true;
    }
}
