package com.alan.alansdk.alanbase.speaker;

import android.os.Build;
import androidx.annotation.Keep;
import com.alan.alansdk.Alan;
import com.alan.alansdk.logging.AlanLogger;

public class AlanARMSpeaker implements SpeakerDumpListener, AlanSpeaker {

    private SpeakerThread speakerThread;
    private Alan alan;

    public AlanARMSpeaker(Alan alan) {
        this.alan = alan;
    }

    @Override
    public synchronized void stopPlaying() {
        if (speakerThread == null) {
            return;
        }
        speakerThread.stopPlaying();
    }

    @Override
    public synchronized void release() {
        if (speakerThread == null) {
            return;
        }
        try {
            speakerThread.release();
            speakerThread.join();
        } catch (InterruptedException e) {
            AlanLogger.e(e);
        }
    }

    @Override
    public synchronized void startPlaying() {
        if (speakerThread == null || !speakerThread.isAlive()) {
            speakerThread = new SpeakerThread(this, alan.isTV);
            speakerThread.start();
        }
        speakerThread.interrupt();
    }

    @Override
    public float[] retrieveAudioBuffer() {
        return alan.readFromNative();
    }
}
