package com.alan.alansdk.button.animations;

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;

public class InnerBgListenAnimation extends BaseAnimation {

    private View bgView;

    public InnerBgListenAnimation(View bg) {
        this.bgView = bg;
    }

    @Override
    protected AnimatorSet buildAnimator() {
        anim = new AnimatorSet();

        ObjectAnimator bgScaleXAnimation = getScaleAnimation(bgView, "scaleX");
        ObjectAnimator bgScaleYAnimation = getScaleAnimation(bgView, "scaleY");
        anim.playTogether(
                bgScaleXAnimation,
                bgScaleYAnimation);
        return anim;
    }

    private ObjectAnimator getScaleAnimation(View view, String property) {

        ObjectAnimator animation = ObjectAnimator.ofFloat(view,
                property,
                1.0f, 1.0f);

        animation.setDuration(AnimationConfig.LISTEN_ANIMATION_TIME);
        animation.setInterpolator(new AccelerateDecelerateInterpolator());
        animation.setRepeatCount(ValueAnimator.INFINITE);
        animation.setRepeatMode(ValueAnimator.REVERSE);
        return animation;
    }

    @Override
    public void stopAnimation() {
        super.stopAnimation();
        bgView.setScaleX(1.0f);
        bgView.setScaleY(1.0f);
    }
}
