package com.alan.alansdk.events;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;

public class EventRecognised {

    public static final String EVENT_NAME = "recognized";

    @SerializedName("final")
    private boolean isFinal;
    @SerializedName("text")
    private String text;
    @SerializedName("reqId")
    private String reqId;
    @SerializedName("screenshotUrl")
    private String screenshotUrl;

    public String getReqId() {
        return reqId;
    }

    public String getScreenshotUrl() {
        return screenshotUrl;
    }

    public String getText() {
        return text;
    }

    public boolean isFinal() {
        return isFinal;
    }

    public EventRecognised(boolean isFinal, String text) {
        this.isFinal = isFinal;
        this.text = text;
    }

    public static EventRecognised fromJson(String json) {
        Gson gson = new Gson();
        return gson.fromJson(json, EventRecognised.class);
    }
}
