package com.alan.alansdk;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import android.view.View;
import androidx.annotation.Nullable;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class Utils {

    public static short[] floatsToShorts(float[] floats) {
        short[] shorts = new short[floats.length];
        for (int i = 0; i < floats.length; i++) {
            short s = (short) (floats[i] * 32767);
            shorts[i] = s;
        }
        return shorts;
    }

    public static float[] shortsToFloat(short[] pcms) {
        float[] floats = new float[pcms.length];
        for (int i = 0; i < pcms.length; i++) {
            floats[i] = ((float)pcms[i])/0x8000;
        }
        return floats;
    }

    public static String getDeviceInfo(Context context) {
        final StringBuilder sb = new StringBuilder("\n\n---\n");
        sb.append("Model: ").append(Build.MODEL).append('\n');
        sb.append("Brand: ").append(Build.BRAND).append('\n');
        sb.append("Device: ").append(Build.DEVICE).append('\n');
        sb.append("Display: ").append(Build.DISPLAY).append('\n');
        sb.append("Hardware: ").append(Build.HARDWARE).append('\n');
        sb.append("Manufacturer: ").append(Build.MANUFACTURER).append('\n');
        sb.append("Host: ").append(Build.HOST).append('\n');
        sb.append("Release: ").append(Build.VERSION.RELEASE).append('\n');
        sb.append("Board: ").append(Build.BOARD).append('\n');
        sb.append("Radio: ").append(Build.RADIO).append('\n');
        sb.append("Product: ").append(Build.PRODUCT).append('\n');
        return sb.toString();
    }
    public static boolean isTV(Context context) {
        if (Build.BRAND.equals("Droidlogic") || Build.MANUFACTURER.equals("Droidlogic")) {
            return true;
        } else {
            return context.getPackageManager().hasSystemFeature(PackageManager.FEATURE_LEANBACK);
        }
    }
    public static Activity getActivityFromView(View v) {
        Context context = v.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    public static String extractFileNameFromUrl(@Nullable String url) {
        if (url == null) {
            return "";
        }
        if (!url.startsWith("/data/user")) {
            try {
                URL resource = new URL(url);
                String host = resource.getHost();
                if (host.length() > 0 && url.endsWith(host)) {
                    // handle ...example.com
                    return "";
                }
            } catch (MalformedURLException e) {
                return "";
            }
        }

        int startIndex = url.lastIndexOf('/') + 1;
        int length = url.length();

        // find end index for ?
        int lastQMPos = url.lastIndexOf('?');
        if (lastQMPos == -1) {
            lastQMPos = length;
        }

        // find end index for #
        int lastHashPos = url.lastIndexOf('#');
        if (lastHashPos == -1) {
            lastHashPos = length;
        }

        // calculate the end index
        int endIndex = Math.min(lastQMPos, lastHashPos);
        String lastPathComponent = url.substring(startIndex, endIndex);
        lastPathComponent = lastPathComponent.toLowerCase().replace(".zip", "");
        return lastPathComponent;
    }

    public static File getWakeWordZipPath(Context context, String modelName) {
        return new File(context.getFilesDir() + "/wakeword/" + modelName + "/" + modelName + ".zip");
    }

    public static File getWakeWordModelPath(Context context, String modelName) {
        return new File(context.getFilesDir() + "/wakeword/" + modelName + "/");
    }

    static boolean isNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        if (cm != null) {
            NetworkInfo networkInfo = cm.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        return false;
    }

    static void registerConnectivityNetworkMonitorForAPI21AndUp(Context context, ConnectivityManager.NetworkCallback callback) {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
            return;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkRequest.Builder builder = new NetworkRequest.Builder();
        connectivityManager.registerNetworkCallback(builder.build(), callback);
    }
}
