package com.alan.alansdk.alanbase;

import android.content.Context;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.MediaRecorder;
import android.content.pm.PackageManager;
import android.os.Build;

import com.alan.alansdk.AlanConfig;
import com.alan.alansdk.Utils;
import com.alan.alansdk.logging.AlanLogger;

import okhttp3.internal.Util;

public class AudioConfig {
    public static int SAMPLE_RATE = 44100;
    public static int AUDIO_FORMAT = AudioFormat.ENCODING_PCM_FLOAT;
    public final static int SKIP_MILLIS_ON_START = 430;

    public static void determineSupportedSampleRate(Context context) {
        AlanLogger.i("Determine supported sample rate");
        boolean isTV = Utils.isTV(context);
        AlanLogger.i("Alan is running on TV - " + isTV);
        int[] sampleRates = new int[]{44100, 16000};
        AUDIO_FORMAT = isTV ? AudioFormat.ENCODING_PCM_16BIT : AudioFormat.ENCODING_PCM_FLOAT;
        AlanLogger.i("Determined audio format - " + AUDIO_FORMAT);
        for (int sampleRate : sampleRates) {
            AlanLogger.i("Determine supported sample rate - " + sampleRate);
            if (validateSampleRate(sampleRate, AUDIO_FORMAT)) {
                AlanLogger.i("Determined sample rate - " + sampleRate);
                SAMPLE_RATE = sampleRate;
                break;
            }
        }
    }

    public static boolean validateSampleRate(int sampleRate, int audioFormat) {
        AudioRecord recorder = null;
        try {
            int bufferSize = AudioRecord.getMinBufferSize(
                    sampleRate,
                    AudioFormat.CHANNEL_IN_MONO,
                    audioFormat
            );
            AlanLogger.i("Validate sample rate - bufferSize - " + bufferSize);
            recorder = new AudioRecord(
                    MediaRecorder.AudioSource.MIC,
                    sampleRate,
                    AudioFormat.CHANNEL_IN_MONO,
                    audioFormat,
                    bufferSize
            );
        } catch(IllegalArgumentException e) {
            AlanLogger.e(e);
            return false;
        } finally {
            if(recorder != null)
                recorder.release();
        }
        return true;
    }
}
