package com.alan.alansdk.alanbase.recorder;

import android.os.Build;
import android.os.Environment;

import androidx.annotation.Keep;

import com.alan.alansdk.Alan;
import com.alan.alansdk.logging.AlanLogger;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class AlanRecorder implements RecordDumpListener {
//    String filePath = "/sdcard/Download/recordings/file.wav";
//    String dirPath = "/sdcard/Download/recordings";
//    FileOutputStream fos = null;
//    DataOutputStream dos = null;

    private Alan alan;

    public AlanRecorder(Alan alan) {
        this.alan = alan;
    }

    private RecorderThread recorderThread;

    public synchronized void stopRecording() {
        if (recorderThread == null || !recorderThread.shouldContinue) {
            return;
        }
//        if (fos != null && dos != null) {
//            try {
//                dos.close();
//                fos.close();
//            } catch (IOException e) {
//                throw new RuntimeException(e);
//            }
//        }
        recorderThread.stopRecording();
    }

    public synchronized void startRecording() {
        if (recorderThread != null && recorderThread.isAlive()) {
            AlanLogger.i("Recorder already started");
            return;
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            recorderThread = new RecorderApi23(this);
        } else {
            recorderThread = new RecorderApi21(this);
        }
//        if (!Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)){
//            //
//        } else {
//            File folder = new File(dirPath);
//            folder.mkdirs();
//            File file = new File(filePath);
//        }
//        try {
//            fos = new FileOutputStream(filePath);
//            dos = new DataOutputStream(fos);
//        } catch (FileNotFoundException e) {
//            throw new RuntimeException(e);
//        }
        recorderThread.start();
    }

    public synchronized void skipMillis(int millis) {
        if (recorderThread != null) {
            recorderThread.skipMillis(millis);
        }
    }

    @Override
    public void onRecordDump(float[] dump) {
//        if (fos != null && dos != null) {
//            try {
//                byte buf[] = new byte[4*dump.length];
//                for (int i=0; i<dump.length; ++i)
//                {
//                    int val = Float.floatToRawIntBits(dump[i]);
//                    buf[4 * i] = (byte) (val >> 24);
//                    buf[4 * i + 1] = (byte) (val >> 16) ;
//                    buf[4 * i + 2] = (byte) (val >> 8);
//                    buf[4 * i + 3] = (byte) (val);
//                }
//                dos.write(buf);
//            } catch (IOException e) {
//                throw new RuntimeException(e);
//            }
//        }
        alan.writeFrameNative(dump);
    }
}
