package com.alan.alansdk.wakeword;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import android.util.Log;

import com.alan.alansdk.Utils;
import com.alan.alansdk.logging.AlanLogger;
import com.alan.alansdk.prefs.AlanPrefs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtils {

    public static void unzip(File zipFile, File targetDirectory) throws IOException {
        ZipInputStream zis = new ZipInputStream(
                new BufferedInputStream(new FileInputStream(zipFile)));
        try {
            ZipEntry ze;
            int count;
            byte[] buffer = new byte[8192];
            while ((ze = zis.getNextEntry()) != null) {
                File file = new File(targetDirectory, ze.getName());
                File dir = ze.isDirectory() ? file : file.getParentFile();
                if (!dir.isDirectory() && !dir.mkdirs())
                    throw new FileNotFoundException("Failed to ensure directory: " +
                            dir.getAbsolutePath());
                if (ze.isDirectory())
                    continue;
                FileOutputStream fout = new FileOutputStream(file);
                try {
                    while ((count = zis.read(buffer)) != -1)
                        fout.write(buffer, 0, count);
                } finally {
                    fout.close();
                }
            }
        } finally {
            zis.close();
        }
    }

    public static String copyZipFromDownloads(Context context, String modelName) {
        InputStream in = null;
        OutputStream out = null;

        String result = "";
        try {
            File inFile = context.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS + "/wakeword/" + modelName + "/" + modelName + ".zip");
            if (inFile != null && !inFile.exists()) {
                return result;
            }
            in = new FileInputStream(inFile);

            File outDir = Utils.getWakeWordModelPath(context, modelName);
            if (!outDir.exists()) {
                outDir.mkdirs();
            }

            File outFile = Utils.getWakeWordZipPath(context, modelName);
            outFile.createNewFile();

            out = new FileOutputStream(outFile);
            copyFile(in, out);
            in.close();
            in = null;
            out.flush();
            out.close();
            out = null;

            result = outFile.getAbsolutePath();
        } catch (IOException e) {
            Log.e("tag", "Failed to copy asset file: " + modelName, e);
        }
        return result;
    }

    private static void copyFile(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int read;
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }
}
