package com.alan.alansdk.wakeword;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import com.alan.alansdk.Utils;
import static android.content.Context.DOWNLOAD_SERVICE;

public class ModelDownloader {

    private DownloadListener callback;
    private String url;

    private BroadcastReceiver onComplete = new BroadcastReceiver() {
        public void onReceive(Context ctxt, Intent intent) {
            if (callback != null) {
                callback.onDownloaded(url);
            }
        }
    };

    public void download(Context context, DownloadListener downloadListener, String path) {

        callback = downloadListener;
        this.url = path;

        DownloadManager mgr = (DownloadManager) context.getSystemService(DOWNLOAD_SERVICE);

        if (mgr == null) {
            if (callback != null) {
                callback.onDownloadFailed();
            }
            return;
        }

        if (Build.VERSION.SDK_INT >= 34 && context.getApplicationInfo().targetSdkVersion >= 34) {
            context.registerReceiver(onComplete, new IntentFilter(DownloadManager.ACTION_DOWNLOAD_COMPLETE), Context.RECEIVER_NOT_EXPORTED);
        } else {
            context.registerReceiver(onComplete, new IntentFilter(DownloadManager.ACTION_DOWNLOAD_COMPLETE));
        }

        startDownload(context, mgr, path);
    }

    private void startDownload(Context context, DownloadManager mgr, String modelPath) {
        Uri uri = Uri.parse(modelPath);
        String modelName = Utils.extractFileNameFromUrl(modelPath);

        long lastDownload = mgr.enqueue(new DownloadManager.Request(uri)
                .setAllowedNetworkTypes(DownloadManager.Request.NETWORK_WIFI | DownloadManager.Request.NETWORK_MOBILE)
                .setAllowedOverRoaming(false)
                .setTitle("Updating")
                .setDescription("")
                .setDestinationInExternalFilesDir(context, Environment.DIRECTORY_DOWNLOADS,  "/wakeword/" + modelName + "/" + modelName + ".zip")
        );
    }
}
