package com.alan.alansdk;

import android.content.Context;

import androidx.annotation.Nullable;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class Utils {

    public static String extractFileNameFromUrl(@Nullable String url) {
        if (url == null) {
            return "";
        }
        if (!url.startsWith("/data/user")) {
            try {
                URL resource = new URL(url);
                String host = resource.getHost();
                if (host.length() > 0 && url.endsWith(host)) {
                    // handle ...example.com
                    return "";
                }
            } catch (MalformedURLException e) {
                return "";
            }
        }

        int startIndex = url.lastIndexOf('/') + 1;
        int length = url.length();

        // find end index for ?
        int lastQMPos = url.lastIndexOf('?');
        if (lastQMPos == -1) {
            lastQMPos = length;
        }

        // find end index for #
        int lastHashPos = url.lastIndexOf('#');
        if (lastHashPos == -1) {
            lastHashPos = length;
        }

        // calculate the end index
        int endIndex = Math.min(lastQMPos, lastHashPos);
        return url.substring(startIndex, endIndex);
    }

    public static File getWakeWordModelFile(Context context, String modelName) {
        return new File(context.getFilesDir() + "/wakeword/" + modelName);
    }
}
