package com.alan.alansdk.wakeword;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Log;

import com.alan.alansdk.prefs.AlanPrefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtils {

    public static String copyTfModel(Context context) {
        String filename = AlanPrefs.DEF_WAKEWORD_NAME;

        AssetManager assetManager = context.getAssets();
        InputStream in = null;
        OutputStream out = null;

        String result = "";
        try {
            in = assetManager.open(filename);

            File outDir = new File(context.getFilesDir() + "/wakeword/");

            if (!outDir.exists()) {
                outDir.mkdirs();
            }

            File outFile = new File(outDir, filename);
            outFile.createNewFile();

            out = new FileOutputStream(outFile);
            copyFile(in, out);
            in.close();
            in = null;
            out.flush();
            out.close();
            out = null;

            result = outFile.getAbsolutePath();
        } catch (IOException e) {
            Log.e("tag", "Failed to copy asset file: " + filename, e);
        }

        return result;
    }

    private static void copyFile(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int read;
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }
}
