package com.alan.alansdk;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.IBinder;

import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;

import com.alan.alansdk.logging.AlanLogger;

public class AlanService extends Service {

    public static boolean isRunning = false;

    private final static String TYPE = "type";
    private final static String TYPE_RECOGNIZED = "recognized";
    private final static String TYPE_RESPONSE = "response";
    private final static String TYPE_UNKNOWN = "unknown";
    private final static String PAYLOAD = "payload";

    private final static int SPEECH_2_TEXT_NOTIFICATION_ID = 101;

    public static Intent getSpeechIntent(Context context, String speech) {
            Intent intent = new Intent(context, AlanService.class);
            intent.putExtra(TYPE, TYPE_RECOGNIZED);
            if (speech != null) {
                intent.putExtra(PAYLOAD, speech);
            }
            return intent;
    }

    public static final String CHANNEL_ID = "AlanForegroundServiceChannelID";
    public static final String SPEECH_TO_TEXT_CHANNEL_ID = "AlanSpeechToTextChannelID";

    @Override
    public void onCreate() {
        super.onCreate();
        isRunning = true;
    }

    private Notification buildNotification(String text) {
        PackageManager pm = getPackageManager();
        Intent notificationIntent = pm.getLaunchIntentForPackage(getPackageName());
        PendingIntent pendingIntent = PendingIntent.getActivity(this,
                0, notificationIntent, 0);
        return new NotificationCompat.Builder(this, CHANNEL_ID)
                .setContentTitle("Alan Service")
                .setContentText(text)
                .setSmallIcon(R.drawable.ic_button_logo_state_01)
                .setContentIntent(pendingIntent)
                .build();
    }

    private Notification buildS2TNotification(String text) {
        PackageManager pm = getPackageManager();
        Intent notificationIntent = pm.getLaunchIntentForPackage(getPackageName());
        PendingIntent pendingIntent = PendingIntent.getActivity(this,
                0, notificationIntent, 0);
        return new NotificationCompat.Builder(this, SPEECH_TO_TEXT_CHANNEL_ID)
                .setContentTitle("Alan Service")
                .setContentText(text)
                .setSmallIcon(R.drawable.ic_button_logo_state_01)
//                .setContentIntent(pendingIntent)
                .build();
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null) {
            return START_STICKY;
        }
        if (intent.hasExtra(TYPE)) {
            if (intent.hasExtra(PAYLOAD)) {
                String text = intent.getStringExtra(PAYLOAD);

                Notification notification = buildS2TNotification(text);
                //NotificationManager manager = getSystemService(NotificationManager.class);
                NotificationManager manager = (NotificationManager) getApplicationContext().getSystemService(Context.NOTIFICATION_SERVICE);
                manager.notify(SPEECH_2_TEXT_NOTIFICATION_ID, notification);
            } else {
//                NotificationManager manager = getSystemService(NotificationManager.class);
                NotificationManager manager = (NotificationManager) getApplicationContext().getSystemService(Context.NOTIFICATION_SERVICE);
                manager.cancel(SPEECH_2_TEXT_NOTIFICATION_ID);
            }
        } else {
            String appName = getResources().getString(R.string.app_name);
            createNotificationChannel();
            createSpeech2TextChannel();
            Notification notification = buildNotification(appName + " is listening to your microphone");
            startForeground(1, notification);
        }
        return START_STICKY;
    }


    private void createNotificationChannel() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            NotificationChannel serviceChannel = new NotificationChannel(
                    CHANNEL_ID,
                    "Alan foreground service",
                    NotificationManager.IMPORTANCE_LOW
            );
//            NotificationManager manager = getSystemService(NotificationManager.class);
            NotificationManager manager = (NotificationManager) getApplicationContext().getSystemService(Context.NOTIFICATION_SERVICE);
            manager.createNotificationChannel(serviceChannel);
        }
    }

    private void createSpeech2TextChannel() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            NotificationChannel speech2TextChannel = new NotificationChannel(
                    SPEECH_TO_TEXT_CHANNEL_ID,
                    "Alan speech recognition channel",
                    NotificationManager.IMPORTANCE_HIGH
            );
//            NotificationManager manager = getSystemService(NotificationManager.class);
            NotificationManager manager = (NotificationManager) getApplicationContext().getSystemService(Context.NOTIFICATION_SERVICE);
            manager.createNotificationChannel(speech2TextChannel);
        }
    }

    @Override
    public void onDestroy() {
        AlanLogger.i("Service destroyed");
        isRunning = false;
        super.onDestroy();
    }

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }
}
