package com.alan.alansdk.button.animations;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;

import com.alan.alansdk.R;

public class LogoAnimation extends BaseAnimation {

    private Integer[] logoStates = new Integer[]
            {
                    R.drawable.button_logo_state_01,
                    R.drawable.button_logo_state_02,
                    R.drawable.button_logo_state_03,
                    R.drawable.button_logo_state_04,
                    R.drawable.button_logo_state_05,
                    R.drawable.button_logo_state_06,
                    R.drawable.button_logo_state_07,
                    R.drawable.button_logo_state_08,
                    R.drawable.button_logo_state_09,
                    R.drawable.button_logo_state_10
            };

    private ImageView logoView1;
    private ImageView logoView2;
    private String customLogoUrl;

    public LogoAnimation(ImageView logo1, ImageView logo2, String customLogo) {
        logoView1 = logo1;
        logoView2 = logo2;
        customLogoUrl = customLogo;
    }

    private AnimatorSet getLogoAnimationSet() {
        ObjectAnimator animationX1 = getLogoAnimation(logoView1, "scaleX");
        ObjectAnimator animationY1 = getLogoAnimation(logoView1, "scaleY");
        ObjectAnimator animationX2 = getLogoAnimation(logoView2, "scaleX");
        ObjectAnimator animationY2 = getLogoAnimation(logoView2, "scaleY");
        AnimatorSet animation = new AnimatorSet();
        animation.playTogether(animationX1, animationX2, animationY1, animationY2);
        return animation;
    }

    private ObjectAnimator getLogoAnimation(ImageView img, String property) {
        ObjectAnimator animation = ObjectAnimator.ofFloat(img,
                property,
                1.0f, 0.9f);

        animation.setDuration(AnimationConfig.LOGO_SCALE_TIME);
        animation.setInterpolator(new AccelerateDecelerateInterpolator());
        animation.setRepeatCount(ValueAnimator.INFINITE);
        animation.setRepeatMode(ValueAnimator.REVERSE);
        return animation;
    }

    private ObjectAnimator getLogoStateAnimation(ImageView logoView, int index) {
        ObjectAnimator animation = ObjectAnimator.ofFloat(logoView,
                "alpha",
                index == 0 ? 1.0f : 0.0f,
                index == 0 ? 0.0f : 1.0f);

        animation.setDuration(AnimationConfig.LOGO_TRANSACTION_TIME);
        animation.addListener(new Animator.AnimatorListener() {
                                  @Override
                                  public void onAnimationStart(Animator animation) {

                                  }

                                  @Override
                                  public void onAnimationEnd(Animator animation) {
                                        logoView1.invalidate();
                                  }

                                  @Override
                                  public void onAnimationCancel(Animator animation) {

                                  }

                                  @Override
                                  public void onAnimationRepeat(Animator animation) {

                                  }
                              }
        );
        animation.setRepeatCount(ValueAnimator.INFINITE);
        animation.setRepeatMode(ValueAnimator.REVERSE);
        animation.addListener(new LogoStateAnimationListener(logoStates, logoView, index));
        return animation;
    }

    @Override
    protected AnimatorSet buildAnimator() {
        anim = new AnimatorSet();
        ObjectAnimator alphaAnimation = getLogoStateAnimation(logoView1, 0);
        ObjectAnimator alphaAnimation2 = getLogoStateAnimation(logoView2, 1);

        if (customLogoUrl == null) {
            anim.playTogether(alphaAnimation, alphaAnimation2, getLogoAnimationSet());
        }
        else {
            anim.playTogether(getLogoAnimationSet());
        }

        return anim;
    }
}
