package com.alan.alansdk.button.animations;

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;

public class SpeakingBackAnimation extends BaseAnimation {

    public enum STATE {
        SPEAKING_BACK,
        IDLE;
    }

    private View innerBgView;

    private STATE state;

    public SpeakingBackAnimation(View bg, STATE state) {
        this.innerBgView = bg;
        this.state = state;
    }

    public void setState(STATE state) {
        this.state = state;
        stopAnimation();
        anim = null; //force animation recreate
    }

    public void startSpeakingBackAnimation() {
        setState(STATE.SPEAKING_BACK);
        startAnimation();
    }

    public void startRespondingAnimation() {
        setState(STATE.IDLE);
        startAnimation();
    }

    @Override
    protected AnimatorSet buildAnimator() {
        anim = new AnimatorSet();

        if (state == STATE.SPEAKING_BACK) {
            ObjectAnimator bgAnimationX = getScaleAnimation(innerBgView, "scaleX", true);
            ObjectAnimator bgAnimationY = getScaleAnimation(innerBgView, "scaleY", true);
            ObjectAnimator bgAnimationAlpha = getScaleAnimation(innerBgView, "alpha", true);
            anim.playTogether(bgAnimationX, bgAnimationY, bgAnimationAlpha);
        } else {
            ObjectAnimator bgAnimationX = getScaleAnimation(innerBgView, "scaleX", false);
            ObjectAnimator bgAnimationY = getScaleAnimation(innerBgView, "scaleY", false);
            ObjectAnimator bgAnimationAlpha = getScaleAnimation(innerBgView, "alpha", false);
            anim.playTogether(bgAnimationX, bgAnimationY, bgAnimationAlpha);
        }
        return anim;
    }

    private ObjectAnimator getScaleAnimation(View view, String property, boolean collapsing) {

        ObjectAnimator animation = ObjectAnimator.ofFloat(view,
                property,
                collapsing ? 1.0f : 0.0f,
                collapsing ? 0.0f : 1.0f);

        animation.setInterpolator(new AccelerateDecelerateInterpolator());
        animation.setDuration(AnimationConfig.REPLY_ANIMATION_TIME);
        animation.setRepeatCount(0);
        return animation;
    }
}
