package com.alan.alansdk.events;

import android.graphics.Color;

import androidx.annotation.Nullable;

import com.alan.alansdk.Utils;
import com.alan.alansdk.prefs.AlanPrefs;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class EventOptions implements Serializable {

    public static final String EVENT_NAME = "options";

    @SerializedName("projectName")
    public String projectName;
    @SerializedName("android")
    private AndroidSettings androidSettings;
    @SerializedName("wakewordPath")
    public String wakeWordPath;

    public String getWakeWordModelName() {
        return Utils.extractFileNameFromUrl(wakeWordPath);
    }

    public static EventOptions fromJson(String json) {
        Gson gson = new Gson();
        return gson.fromJson(json, EventOptions.class);
    }

    public AndroidSettings getAndroidSettings() {
        if (androidSettings == null) {
            return new AndroidSettings();
        } else {
            return androidSettings;
        }
    }

    public static class ButtonColor implements Serializable {
        @SerializedName("background")
        public AlanColor background;
//        @SerializedName("hover")
//        public List<String> hover; //Not used on mobile
        @SerializedName("shadow")
        public AlanColor shadow;
    }

    public static class AlanColor implements Serializable {
        @SerializedName("angle")
        public int angle;
        @SerializedName("color")
        public List<String> colorList;

        public int getFirstColor() {
            if (colorList.size() > 0) {
                return Color.parseColor(colorList.get(0));
            } else {
                return Color.BLUE;
            }
        }

        public int getSecondColor() {
            if (colorList.size() > 1) {
                return Color.parseColor(colorList.get(1));
            } else {
                return Color.BLUE;
            }
        }

        public AlanColor() {}

        public AlanColor(String color1, String color2) {
            angle = 45;
            colorList = Arrays.asList(color1, color2);
        }
    }

    public static class AndroidSettings implements Serializable {

        @SerializedName("hidden")
        public boolean isButtonHidden = false;
        @SerializedName("btnOptions")
        public ButtonOptions buttonOptions;
        @Nullable
        @SerializedName("wakeWordEnabled")
        private Boolean isWakeWordEnabled;
        @SerializedName("selectedBtnOptionId")
        public String btnOptionId;
        @Nullable
        @SerializedName("timeout")
        private Long timeout;
        @SerializedName("hideS2TPanel")
        private boolean hideS2TPanel = false;
        @SerializedName("screenshotEnabled")
        private boolean screenShotsEnabled;
        @SerializedName("keepMicrophoneInBackground")
        public boolean keepMicrophoneInBackground;
        @SerializedName("wakeWordInBackground")
        public boolean wakeWordInBackground;
        @Nullable
        @SerializedName("logoUrl")
        public String logoUrl;

        public boolean isScreenShotsEnabled() {
            return screenShotsEnabled;
        }

        public Boolean isWakeWordEnabled() {
            if (isWakeWordEnabled == null) {
                return AlanPrefs.DEFAULT_WAKEWORD_STATE;
            } else {
                return isWakeWordEnabled;
            }
        }

        public Long getTimeout() {
            if (timeout == null) {
                return AlanPrefs.DEFAULT_TIMEOUT;
            } else {
                return timeout;
            }
        }

        public boolean shouldHideS2TPanel() {
            return hideS2TPanel;
        }

        public static class ButtonOptions implements Serializable {
            @SerializedName("idle")
            public ButtonColor idleColor;
            @SerializedName("listen")
            public ButtonColor listenColor;
            @SerializedName("process")
            public ButtonColor processColor;
            @SerializedName("reply")
            public ButtonColor replyColor;
        }
    }
}
