package com.alan.alansdk.logging;

import android.content.Context;
import android.util.Log;

import com.alan.alansdk.BuildConfig;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.LinkedList;
import java.util.List;

public class AlanLogger {

    public static enum LogLevel {
        BASIC("B/"),
        EVENTS("E/");

        String prefix;

        LogLevel(String prefix) {
            this.prefix = prefix;
        }
    }

    private static final String LOG_FILE_NAME = "alan_logs.txt";

    public static boolean SHOULD_LOG = BuildConfig.DEBUG;
    public static boolean LOG_2_FILE = false;

    private static List<String> logs = new LinkedList<>();

    private AlanLogger() {

    }

    public static void init(Context context) {
        createLogFile(context);
    }

    private static String extractTag() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String tag = stackTraceElements[4].getClassName();
        return tag;
    }

    public static void d(String msg) {
//        if (SHOULD_LOG) {
//            Log.d(extractTag(), msg);
//        }
//        if (LOG_2_FILE) {
//            log2File(LogLevel.BASIC, msg);
//        }
    }

    public static void i(String msg) {
        if (SHOULD_LOG) {
            Log.i(extractTag(), msg);
        }
        if (LOG_2_FILE) {
            log2File(LogLevel.BASIC, msg);
        }
    }

    public static void w(String msg) {
        if (SHOULD_LOG) {
            Log.w(extractTag(), msg);
        }
        if (LOG_2_FILE) {
            log2File(LogLevel.BASIC, msg);
        }
    }

    public static void e(String msg) {
        if (SHOULD_LOG) {
            Log.e(extractTag(), msg);
        }
        if (LOG_2_FILE) {
            log2File(LogLevel.BASIC, msg);
        }
    }

    public static void event(String msg) {
        if (SHOULD_LOG) {
            Log.i(extractTag(), msg);
        }
        if (LOG_2_FILE) {
            log2File(LogLevel.EVENTS, msg);
        }
    }

    public static void e(Exception e) {
        e(e.getMessage());
    }

    private static File logFile;
    private static FileWriter logWriter;

    private static void createLogFile(Context context) {
        File file = new File(context.getFilesDir(), "logs");
        if (!file.exists()) {
            file.mkdir();
        }

        logFile = new File(file, LOG_FILE_NAME);
        if (logFile.exists()) {
            logFile.delete();
        }
        try {
            logFile.createNewFile();
            logWriter = new FileWriter(logFile);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void log2File(LogLevel logLevel, String body) {
        try {
            logWriter.append("\n");
            logWriter.append(logLevel.prefix);
            logWriter.append(body);
//            logWriter.append("\n");
            logWriter.flush();

            logs.add(logLevel.prefix + body);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void onDestroy() {
        try {
            logWriter.flush();
            logWriter.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        logs = null;
    }

    public static String readLogsFromFile(LogLevel logLevel) {
        StringBuilder text = new StringBuilder();

        if (true) {
            if (logs != null && logs.size() > 0) {
                for (String str : logs) {
                    if (logLevel != LogLevel.BASIC && str.startsWith(LogLevel.BASIC.prefix)) {
                        continue;
                    }
                    text.append(str.substring(2));
                    text.append("\n\n");
                }
            }
        } else {
            try {
                BufferedReader br = new BufferedReader(new FileReader(logFile));
                String line;

                while ((line = br.readLine()) != null) {
                    if (logLevel != LogLevel.BASIC && line.startsWith(LogLevel.BASIC.prefix)) {
                        continue;
                    }
                    text.append(line.substring(2));
                    text.append("\n\n");
                }
                br.close();
            } catch (Exception e) {
                //
            }
        }
        return text.toString();
    }
}
