package app.appnomix.sdk.internal.domain

import android.content.Context
import android.content.SharedPreferences
import app.appnomix.sdk.internal.data.SdkConfig
import app.appnomix.sdk.internal.domain.model.Coupon
import app.appnomix.sdk.internal.domain.model.Demand

class CouponCoordinator(
    private val context: Context,
    private val repo: CouponsRepo,
    private val sdkConfig: SdkConfig
) {
    private val prefs: SharedPreferences by lazy {
        context.getSharedPreferences(
            SdkConfig.PREFS_NAME, Context.MODE_PRIVATE
        )
    }

    fun matchAgainstUrl(addressUrl: String): List<Any> {
        return repo.matchByUrlAndLocation(
            url = addressUrl, countryCode = sdkConfig.countryCode
        )
    }

    fun snoozeItem(item: Any) {
        when (item) {
            is Coupon -> repo.markAsSnoozed(item)
            is Demand -> repo.markAsSnoozed(item)
        }
    }

    fun markAsAlwaysApply(item: Any) {
        when (item) {
            is Coupon -> item.brandDomain
            is Demand -> item.rootDomain
            else -> null
        }?.let {
            prefs.edit().putBoolean(it, true).apply()
        }
    }

    fun shouldAlwaysApply(item: Any): Boolean {
        return when (item) {
            is Coupon -> prefs.getBoolean(item.brandDomain, false)
            is Demand -> sdkConfig.alwaysFollowDemands || prefs.getBoolean(item.rootDomain, false)
            else -> false
        }
    }

    fun getById(id: String): Coupon? {
        return repo.getById(id)
    }
}
