package app.appnomix.sdk.internal

import android.annotation.SuppressLint
import android.content.Context
import app.appnomix.sdk.internal.data.SdkConfig
import app.appnomix.sdk.internal.data.network.SaversLeagueApi
import app.appnomix.sdk.internal.domain.CouponCoordinator
import app.appnomix.sdk.internal.domain.CouponsRepo
import app.appnomix.sdk.internal.utils.LocalLocationProvider

@SuppressLint("StaticFieldLeak")
object Deps {
    private lateinit var context: Context
    private val localLocationProvider: LocalLocationProvider by lazy { LocalLocationProvider(context) }
    private val sdkConfig: SdkConfig by lazy {
        SdkConfig(
            context = context,
            localLocationProvider = localLocationProvider
        )
    }
    private val repo: CouponsRepo by lazy {
        CouponsRepo(
            context = context,
            sdkConfig = sdkConfig,
            api = api
        )
    }
    private val api: SaversLeagueApi by lazy { SaversLeagueApi() }
    private val coordinator: CouponCoordinator by lazy {
        CouponCoordinator(
            context = context,
            repo = repo,
            sdkConfig = sdkConfig
        )
    }

    fun localLocationProvider() = localLocationProvider

    fun repo() = repo

    fun api() = api

    fun sdkConfig() = sdkConfig

    fun coordinator() = coordinator

    fun initialize(context: Context) {
        this.context = context
    }
}