package app.appnomix.sdk.internal.data.local

import android.content.Context
import androidx.room.Database
import androidx.room.Room
import androidx.room.RoomDatabase
import androidx.room.TypeConverters
import app.appnomix.sdk.internal.data.local.dao.CouponDao
import app.appnomix.sdk.internal.data.local.dao.DemandDao
import app.appnomix.sdk.internal.data.local.model.CouponEntity
import app.appnomix.sdk.internal.data.local.model.DemandEntity

@Database(
    entities = [
        CouponEntity::class,
        DemandEntity::class
    ],
    version = 1,
)
@TypeConverters(Converters::class)
abstract class SaversLeagueDatabase : RoomDatabase() {

    abstract fun couponsDao(): CouponDao
    abstract fun demandsDao(): DemandDao


    companion object {
        private const val DB_NAME = "saversleague.db"

        fun instance(context: Context): SaversLeagueDatabase {
            return Room.databaseBuilder(
                context = context.applicationContext,
                klass = SaversLeagueDatabase::class.java,
                name = DB_NAME
            ).build()
        }
    }
}
