package app.appnomix.sdk.internal.data.local.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import androidx.room.Transaction
import app.appnomix.sdk.internal.data.local.model.DemandEntity
import java.time.LocalDateTime

@Dao
interface DemandDao {

    @Query("SELECT * FROM demand")
    suspend fun getAll(): List<DemandEntity>

    @Transaction
    suspend fun replace(items: List<DemandEntity>) {
        deleteAll()
        save(items)
    }

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun save(voicemails: List<DemandEntity>)

    @Query("DELETE FROM demand")
    suspend fun deleteAll()

    @Query("UPDATE demand SET snooze_time=:time, snooze_count=:snoozeCount WHERE root_domain=:domain")
    suspend fun updateBrandSnooze(time: LocalDateTime, snoozeCount: Int, domain: String)
}
