package app.appnomix.sdk.internal.data.local.model

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey
import app.appnomix.sdk.internal.domain.model.Coupon
import java.time.LocalDateTime

@Entity(tableName = "coupon")
data class CouponEntity(
    @ColumnInfo(name = "id") @PrimaryKey val id: String,
    @ColumnInfo(name = "is_homepage") val isHomepageCoupon: Boolean,
    @ColumnInfo(name = "code") val code: String,
    @ColumnInfo(name = "end_date") val endDate: LocalDateTime,
    @ColumnInfo(name = "start_date") val startDate: LocalDateTime,
    @ColumnInfo(name = "click_url") val clickUrl: String,
    @ColumnInfo(name = "brand_domain") val brandDomain: String,
    @ColumnInfo(name = "description") val description: String,
    @ColumnInfo(name = "valid_countries") val validCountriesCodes: Set<String>,
    @ColumnInfo(name = "snooze_time") val snoozeTime: LocalDateTime?,
)

fun CouponEntity.toCoupon(brandImageUrl: String): Coupon {
    return Coupon(
        id = id,
        code = code,
        endDate = endDate,
        startDate = startDate,
        clickUrl = clickUrl,
        brandDomain = brandDomain,
        brandImageUrl = brandImageUrl,
        description = description,
        snoozeTime = snoozeTime,
        isForHomepage = isHomepageCoupon,
        validCountriesCodes = validCountriesCodes.toList(),
    )
}
