package app.appnomix.sdk.internal.data.network.model

import app.appnomix.sdk.internal.utils.SLog
import kotlinx.serialization.KSerializer
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder
import java.time.LocalDateTime
import java.time.ZoneId
import java.time.format.DateTimeFormatter
import java.util.Locale

class TimestampSerializer : KSerializer<LocalDateTime> {
    private val formatter: DateTimeFormatter = DateTimeFormatter
        .ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSS")
        .withLocale(Locale.getDefault())
        .withZone(ZoneId.systemDefault())

    override val descriptor: SerialDescriptor =
        PrimitiveSerialDescriptor("Timestamp", PrimitiveKind.STRING)

    override fun serialize(encoder: Encoder, value: LocalDateTime) {
        encoder.encodeString(formatter.format(value))
    }

    override fun deserialize(decoder: Decoder): LocalDateTime {
        var decoded = ""
        try {
            decoded = decoder.decodeString()
            return LocalDateTime.from(formatter.parse(decoded))
        } catch (e: Exception) {
            SLog.e("Could not parse date: $decoded", e)
            return LocalDateTime.now()
        }

    }
}
