package app.appnomix.sdk.internal.ui

import android.content.Context
import android.graphics.PixelFormat
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.view.WindowManager
import app.appnomix.sdk.R

internal class PopupWindow(private val context: Context) {
    private val windowManager: WindowManager by lazy {
        context.getSystemService(Context.WINDOW_SERVICE) as WindowManager
    }
    private var isShowing = false
    private var overlay: View? = null

    fun show(
        name: String,
        description: String?,
        actionName: String,
        brandImageUrl: String?,
        showPostApplyTransition: Boolean,
        activateListener: () -> Unit,
        onCloseListener: () -> Unit
    ) {
        if (isShowing) {
            return
        }
        isShowing = true
        val params = WindowManager.LayoutParams(
            WindowManager.LayoutParams.MATCH_PARENT,
            WindowManager.LayoutParams.WRAP_CONTENT,
            WindowManager.LayoutParams.TYPE_ACCESSIBILITY_OVERLAY,
            WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE,
            PixelFormat.TRANSLUCENT
        )

        // Position at the bottom
        params.gravity = Gravity.BOTTOM or Gravity.CENTER_HORIZONTAL

        overlay = LayoutInflater.from(context).inflate(R.layout.popup_window, null)
        windowManager.addView(overlay, params)
        val configurator = PopupWindowConfigurator()
        overlay?.apply {
            configurator.configure(
                overlay = this,
                name = name,
                actionName = actionName,
                description = description,
                showPostApplyTransition = showPostApplyTransition,
                brandImageUrl = brandImageUrl,
                onDismiss = {
                    hide()
                    onCloseListener()
                },
                onApply = {
                    activateListener()
                })
        }
    }

    fun hide() {
        overlay?.let {
            isShowing = false
            windowManager.removeView(it)
            overlay = null
        }
    }
}
