package app.appnomix.sdk.internal.utils

import android.util.Log
import com.squareup.picasso.BuildConfig

object SLog {
    var customLogger: CustomLogger? = null

    fun d(message: String) {
        if (BuildConfig.DEBUG) {
            Log.d("[SLC]", message)
            customLogger?.d(message)
        }
    }

    fun i(message: String) {
        Log.i("[SLC]", message)
        customLogger?.i(message)
    }

    fun e(message: String, throwable: Throwable? = null) {
        Log.e("[SLC]", message, throwable)
        customLogger?.e(message, throwable)
    }
}

interface CustomLogger {
    fun d(message: String)
    fun i(message: String)
    fun e(message: String, throwable: Throwable? = null)
}