package app.appnomix.sdk.internal.utils

import android.content.Context
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Job
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import kotlin.time.Duration
import kotlin.time.Duration.Companion.seconds

internal object Debounce {
    private var debounceJob: Job? = null

    fun execute(
        duration: Duration = 3.seconds,
        scope: CoroutineScope,
        destinationFunction: () -> Unit
    ) {
        debounceJob?.cancel()
        debounceJob = scope.launch {
            delay(duration.inWholeMilliseconds)
            destinationFunction()
        }
    }
}
