package app.appnomix.sdk.internal.data.local.model

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey
import app.appnomix.sdk.internal.domain.model.Demand
import java.time.LocalDateTime

@Entity(tableName = "demand")
data class DemandEntity(
    @PrimaryKey(autoGenerate = true) val id: Int = 0,
    @ColumnInfo(name = "redirect_url") val redirectUrl: String,
    @ColumnInfo(name = "root_domain") val rootDomain: String,
    @ColumnInfo(name = "country_code") val countryCode: String?,
    @ColumnInfo(name = "snooze_time") val snoozeTime: LocalDateTime?,
    @ColumnInfo(name = "snooze_count") val snoozeCount: Int,
)

fun DemandEntity.toDemand(brandImageUrl: String): Demand {
    return Demand(
        redirectUrl = redirectUrl,
        rootDomain = rootDomain,
        countryCode = countryCode,
        snoozeTime = snoozeTime,
        snoozeCount = snoozeCount,
        brandImageUrl = brandImageUrl
    )
}
