package app.appnomix.sdk.internal.data.network

import android.content.Context
import androidx.work.Constraints
import androidx.work.CoroutineWorker
import androidx.work.NetworkType
import androidx.work.PeriodicWorkRequest
import androidx.work.PeriodicWorkRequestBuilder
import androidx.work.WorkerParameters
import app.appnomix.sdk.internal.Deps
import app.appnomix.sdk.internal.utils.LocalLocationProvider
import java.util.concurrent.TimeUnit

class LocationSyncWorker(
    appContext: Context,
    workerParams: WorkerParameters
) : CoroutineWorker(appContext, workerParams) {
    private val locationProvider: LocalLocationProvider by lazy { Deps.localLocationProvider() }

    override suspend fun doWork(): Result {
        try {
            locationProvider.fetchLocation()
        } catch (e: Throwable) {
            return Result.failure()
        }
        return Result.success()
    }

    companion object {
        const val NAME = "location-sync-worker"
        fun create(): PeriodicWorkRequest {
            val constraints =
                Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build()
            return PeriodicWorkRequestBuilder<LocationSyncWorker>(24, TimeUnit.HOURS)
                .setConstraints(constraints)
                .build()
        }
    }
}