package app.appnomix.sdk.internal.domain.browsers

import java.util.Locale

internal object BrowserResolver {
    private val cachedBrowsers = mutableMapOf(
        "com.android.chrome" to ChromeBrowser()
    )

    fun supportedBrowserPackages(): List<String> {
        return listOf(
            "com.android.chrome",
//            "com.opera.browser",
//            "com.microsoft.emmx",
//            "com.brave.browser",
//            "com.duckduckgo.mobile.android",
//            "org.mozilla.firefox"
        )
    }

    fun getBrowser(packageName: String): DeviceBrowser? {
        val lowerCasePackageName = packageName.lowercase(Locale.ROOT)
        return cachedBrowsers[lowerCasePackageName]
    }
}
