package app.appnomix.sdk.internal.ui

import android.content.Context
import android.graphics.drawable.ColorDrawable
import android.view.View
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView
import androidx.core.content.ContextCompat
import app.appnomix.sdk.R
import com.squareup.picasso.Picasso

class PopupWindowConfigurator {
    private var titleTextView: TextView? = null
    private var descriptionTextView: TextView? = null
    private var actionButton: Button? = null
    private var closeImageView: View? = null
    private var brandImageView: ImageView? = null
    private var logoImageView: ImageView? = null

    fun configure(
        overlay: View,
        name: String,
        actionName: String,
        description: String?,
        showPostApplyTransition: Boolean,
        brandImageUrl: String?,
        onDismiss: () -> Unit,
        onApply: () -> Unit
    ) {
        overlay.apply {
            titleTextView = findViewById(R.id.title_textView)
            actionButton = findViewById(R.id.action_button)
            closeImageView = findViewById(R.id.close_imageView)
            brandImageView = findViewById(R.id.brand_imageView)
            logoImageView = findViewById(R.id.logo_imageView)
            descriptionTextView = findViewById(R.id.description_textView)

            val drawable = context.packageManager.getApplicationIcon(context.packageName)
            logoImageView?.setImageDrawable(drawable)

            if (description.isNullOrEmpty()) {
                descriptionTextView?.visibility = View.GONE
            } else {
                descriptionTextView?.visibility = View.VISIBLE
                descriptionTextView?.text = description
            }
            titleTextView?.text = name
            closeImageView?.setOnClickListener {
                onDismiss()
            }
            actionButton?.text = actionName
            actionButton?.setOnClickListener {
                onApplyAction(
                    context = context,
                    showPostApplyTransition = showPostApplyTransition,
                    onApply = onApply
                )
            }
            if (brandImageUrl == null) {
                brandImageView?.visibility = View.GONE
            } else {
                brandImageView?.visibility = View.VISIBLE

                Picasso.get()
                    .load(brandImageUrl)
                    .placeholder(
                        ColorDrawable(
                            ContextCompat.getColor(
                                context,
                                R.color.sdk_outline
                            )
                        )
                    )
                    .into(brandImageView)
            }
        }
    }

    private fun onApplyAction(
        context: Context,
        showPostApplyTransition: Boolean,
        onApply: () -> Unit
    ) {
        actionButton?.visibility = View.GONE
        if (showPostApplyTransition) {
            descriptionTextView?.text = context.getString(R.string.applying_coupons)
        } else {
            descriptionTextView?.text = context.getString(R.string.applying_selection)
        }
        onApply()
    }
}