package app.appnomix.sdk.internal.data.network.model

import androidx.room.PrimaryKey
import app.appnomix.sdk.internal.data.local.model.CouponEntity
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import java.time.LocalDateTime

@Serializable
data class CouponDto(
    @SerialName("id") @PrimaryKey val id: String,
    @SerialName("code") val code: String,
    @Serializable(with = TimestampSerializer::class) @SerialName("end_date") val endDate: LocalDateTime,
    @Serializable(with = TimestampSerializer::class) @SerialName("start_date") val startDate: LocalDateTime,
    @SerialName("click_url") val clickUrl: String,
    @SerialName("brand_domain") val brandDomain: String,
    @SerialName("description") val description: String,
    @SerialName("valid_countries") val validCountriesCodes: List<String>,
)

fun CouponDto.toEntity(isHomepage: Boolean): CouponEntity {
    return CouponEntity(
        id = id,
        code = code,
        endDate = endDate,
        startDate = startDate,
        clickUrl = clickUrl,
        brandDomain = brandDomain,
        description = description,
        isHomepageCoupon = isHomepage,
        validCountriesCodes = validCountriesCodes.toSet(),
        snoozeTime = null
    )
}
