package app.appnomix.sdk.internal.ui

import android.content.Context
import app.appnomix.sdk.R
import app.appnomix.sdk.internal.domain.model.Coupon
import app.appnomix.sdk.internal.domain.model.Demand

class PopupDisplay(
    private val context: Context
) {
    private val popupWindow = PopupWindow(context)

    fun show(
        item: Any,
        onActivateCoupon: () -> Unit,
        onIgnoreCoupon: () -> Unit
    ) {
        when (item) {
            is Coupon -> {
                popupWindow.show(
                    name = item.brandDomain,
                    description = item.description,
                    brandImageUrl = item.brandImageUrl,
                    showPostApplyTransition = true,
                    activateListener = onActivateCoupon,
                    onCloseListener = onIgnoreCoupon,
                    actionName = context.getString(R.string.copy_code)
                )
            }

            is Demand -> {
                popupWindow.show(
                    name = item.rootDomain,
                    description = context.getString(R.string.no_coupon_popup_text),
                    brandImageUrl = item.brandImageUrl,
                    showPostApplyTransition = false,
                    activateListener = onActivateCoupon,
                    onCloseListener = onIgnoreCoupon,
                    actionName = context.getString(R.string.yes_please)
                )
            }
        }
    }

    fun hide() {
        popupWindow.hide()
    }
}
