package app.appnomix.sdk.internal.data.network.model

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class ConfigDto(
    @SerialName("campaign_id")
    val campaignId: String,

    @SerialName("data_refresh_period")
    val dataRefreshPeriodMillis: Long,

    @SerialName("popup_snooze_time")
    val popupSnoozeTimeMillis: Long,

    @SerialName("analytics_endpoint")
    val analyticsEndpoint: String,

    @SerialName("overrides")
    val overrides: Map<String, ConfigurationOverrideDto>? = null
)

@Serializable
data class ConfigurationOverrideDto(
    @SerialName("campaign_id") val campaignId: String
)

@Serializable
data class ConfigContentDto(
    @SerialName("configuration")
    val config: ConfigDto
)
