package app.appnomix.sdk.internal.data.network.model

import app.appnomix.sdk.internal.data.local.model.DemandEntity
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class DemandDto(
    @SerialName("redirect_url") val redirectUrl: String,
    @SerialName("root_domain") val rootDomain: String,
    @SerialName("country_code") val countryCode: String?
)

fun DemandDto.toEntity(): DemandEntity {
    return DemandEntity(
        redirectUrl = redirectUrl,
        rootDomain = rootDomain,
        countryCode = countryCode
    )
}
