package app.appnomix.sdk.internal.domain.machine.states

import CheckoutPageConfig
import android.content.Context
import app.appnomix.sdk.R
import app.appnomix.sdk.internal.domain.machine.states.analytics.logAutoApplyProgressCloseAnalytics
import app.appnomix.sdk.internal.domain.model.Coupon
import app.appnomix.sdk.internal.ui.PopupDisplay
import app.appnomix.sdk.internal.ui.PopupViewData
import app.appnomix.sdk.internal.ui.PopupViewType
import app.appnomix.sdk.internal.utils.SLog

data object ShowAutoApplyProgressNode : UiTreeNode() {

    override suspend fun execute() {
        val popupDisplay = inventory?.get<PopupDisplay>(TreeInventoryType.POPUP_DISPLAY)
        val config = inventory?.get<CheckoutPageConfig>(TreeInventoryType.CHECKOUT_CONFIG)

        config?.let {
            performInMainScope {
                displayAutoApplyProgress(popupDisplay)
                markReadyForTransition(TreeTransition.Positive)
            }
        } ?: markReadyForTransition(TreeTransition.Negative)
    }

    private fun displayAutoApplyProgress(
        popupDisplay: PopupDisplay?
    ) {
        val nextCouponIndexToVerify =
            if (inventory?.contains(TreeInventoryType.COUPON_INDEX_BEING_VERIFIED) == true) {
                inventory?.get<Int>(TreeInventoryType.COUPON_INDEX_BEING_VERIFIED)?.plus(1) ?: 0
            } else {
                inventory?.save(TreeInventoryType.COUPON_INDEX_BEING_VERIFIED, 0)
                0
            }

        val couponList = inventory?.get<List<Coupon>>(TreeInventoryType.COUPON_LIST) ?: listOf()
        val currencySymbol = inventory?.get<String>(TreeInventoryType.CURRENCY_SYMBOL) ?: ""

        val popupViewData = PopupViewData().apply {
            set(PopupViewData.PopupViewDataType.COUPON_LIST, couponList)
            set(PopupViewData.PopupViewDataType.CURRENCY_SYMBOL, currencySymbol)
            set(
                PopupViewData.PopupViewDataType.CURRENT_COUPON_INDEX_BEING_VALIDATED,
                nextCouponIndexToVerify
            )
        }

        popupDisplay?.hide()
        popupDisplay?.show(
            viewType = PopupViewType.TRYING_COUPONS,
            onDismissAction = {
                SLog.d("[aa]: progress popup -> onDismissAction")
                popupDisplay.hide()
                logAutoApplyProgressCloseAnalytics()

                // we need to transition to negative here to make sure the auto-apply flow is stopped
                markReadyForTransition(TreeTransition.Negative)
            },
            data = popupViewData
        )
    }

    override fun pause() {
        performInMainScope {
            inventory?.get<PopupDisplay>(TreeInventoryType.POPUP_DISPLAY)?.apply {
                when (activePopupType()) {
                    PopupViewType.TRYING_COUPONS -> {
                        hide()
                        markReadyForTransition(TreeTransition.Negative)
                    }

                    else -> {}
                }
            }
        }
    }

    override fun positiveChildNode() = ClickBeforeStartNode
    override fun negativeChildNode() = ShowStopProgressNode
}
