package app.appnomix.sdk.internal.data.local

import android.content.Context
import androidx.room.Database
import androidx.room.Room
import androidx.room.RoomDatabase
import androidx.room.TypeConverters
import androidx.sqlite.db.SupportSQLiteDatabase
import app.appnomix.sdk.internal.data.local.dao.ConfigDao
import app.appnomix.sdk.internal.data.local.dao.CouponDao
import app.appnomix.sdk.internal.data.local.dao.DemandDao
import app.appnomix.sdk.internal.data.local.dao.SnoozeDao
import app.appnomix.sdk.internal.data.local.model.ConfigEntity
import app.appnomix.sdk.internal.data.local.model.CouponEntity
import app.appnomix.sdk.internal.data.local.model.CouponInteractionEntity
import app.appnomix.sdk.internal.data.local.model.DemandEntity
import app.appnomix.sdk.internal.data.local.model.DemandInteractionEntity

@Database(
    entities = [
        CouponEntity::class,
        DemandEntity::class,
        DemandInteractionEntity::class,
        CouponInteractionEntity::class,
        ConfigEntity::class,
    ],
    version = 5,
)
@TypeConverters(Converters::class)
abstract class AppnomixDatabase : RoomDatabase() {

    abstract fun couponsDao(): CouponDao
    abstract fun demandsDao(): DemandDao
    abstract fun configDao(): ConfigDao
    abstract fun snoozeDao(): SnoozeDao

    companion object {
        private const val DB_NAME = "appnomix"

        fun instance(context: Context, listener: DatabaseDestructiveMigrationListener): AppnomixDatabase {
            return Room.databaseBuilder(
                context = context.applicationContext,
                klass = AppnomixDatabase::class.java,
                name = DB_NAME,
            )
                .addCallback(object : Callback() {
                    override fun onDestructiveMigration(db: SupportSQLiteDatabase) {
                        super.onDestructiveMigration(db)
                        listener.onDestructiveMigration()
                    }
                })
                .fallbackToDestructiveMigration()
                .build()
        }
    }
}

interface DatabaseDestructiveMigrationListener {
    fun onDestructiveMigration()
}