package app.appnomix.sdk.internal.data.local.model

import androidx.room.ColumnInfo
import androidx.room.Embedded
import androidx.room.Entity
import androidx.room.PrimaryKey
import androidx.room.Relation
import app.appnomix.sdk.internal.domain.model.Coupon
import java.time.LocalDateTime

data class CouponWithInteractionEntity(
    @Embedded
    val couponEntity: CouponEntity,
    @Relation(
        parentColumn = "brand_domain",
        entityColumn = "brand_domain",
    )
    val interactionEntity: CouponInteractionEntity?
)

@Entity(tableName = "coupon")
data class CouponEntity(
    @ColumnInfo(name = "id") @PrimaryKey val id: String,
    @ColumnInfo(name = "is_homepage") val isHomepageCoupon: Boolean,
    @ColumnInfo(name = "code") val code: String,
    @ColumnInfo(name = "end_date") val endDate: LocalDateTime,
    @ColumnInfo(name = "start_date") val startDate: LocalDateTime,
    @ColumnInfo(name = "click_url") val clickUrl: String,
    @ColumnInfo(name = "brand_domain") val brandDomain: String,
    @ColumnInfo(name = "description") val description: String,
    @ColumnInfo(name = "valid_countries") val validCountriesCodes: Set<String>,
)

fun CouponWithInteractionEntity.toCoupon(brandImageUrl: String): Coupon {
    return Coupon(
        id = couponEntity.id,
        code = couponEntity.code,
        endDate = couponEntity.endDate,
        startDate = couponEntity.startDate,
        clickUrl = couponEntity.clickUrl,
        brandDomain = couponEntity.brandDomain,
        brandImageUrl = brandImageUrl,
        description = couponEntity.description,
        lastUseTime = interactionEntity?.lastUseTime,
        isForHomepage = couponEntity.isHomepageCoupon,
        validCountriesCodes = couponEntity.validCountriesCodes.toList(),
    )
}

fun CouponEntity.toCoupon(brandImageUrl: String): Coupon {
    return Coupon(
        id = id,
        code = code,
        endDate = endDate,
        startDate = startDate,
        clickUrl = clickUrl,
        brandDomain = brandDomain,
        brandImageUrl = brandImageUrl,
        description = description,
        isForHomepage = isHomepageCoupon,
        lastUseTime = null,
        validCountriesCodes = validCountriesCodes.toList(),
    )
}
