package app.appnomix.sdk.internal.data.network

import android.content.Context
import androidx.work.BackoffPolicy
import androidx.work.Constraints
import androidx.work.CoroutineWorker
import androidx.work.NetworkType
import androidx.work.OneTimeWorkRequest
import androidx.work.OneTimeWorkRequestBuilder
import androidx.work.WorkerParameters
import app.appnomix.sdk.internal.Deps
import app.appnomix.sdk.internal.data.network.AppnomixDemandsSyncWorker.Companion.MAX_RETRY_COUNT
import app.appnomix.sdk.internal.domain.CouponsRepo
import app.appnomix.sdk.internal.utils.SLog
import java.util.concurrent.TimeUnit

class AppnomixCouponsSyncWorker(
    appContext: Context,
    workerParams: WorkerParameters
) : CoroutineWorker(appContext, workerParams) {
    private val repo: CouponsRepo by lazy { Deps.repo() }

    override suspend fun doWork(): Result {
        if (runAttemptCount >= MAX_RETRY_COUNT) {
            return Result.failure()
        }
        try {
            SLog.i("preparing to fetch coupons data")
            fetchCoupons()
            SLog.i("coupons fetched")
        } catch (e: Throwable) {
            SLog.e("Something went wrong with $NAME", e)
            return Result.retry()
        }
        return Result.success()
    }

    private suspend fun fetchCoupons() {
        repo.fetchHomepageCoupons()
    }

    companion object {
        const val NAME = "coupons-sync-worker"
        fun create(): OneTimeWorkRequest {
            val constraints =
                Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build()
            return OneTimeWorkRequestBuilder<AppnomixCouponsSyncWorker>()
                .setConstraints(constraints)
                .setBackoffCriteria(BackoffPolicy.EXPONENTIAL, 30, TimeUnit.SECONDS)
                .build()
        }
    }
}
